/*
 * $Id: dialI.c,v 1.10 1998/02/17 09:52:58 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/xt/dialI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Intrinsic.h>     /* Intrinsics Definitions*/
#include <X11/StringDefs.h>    /* Standard Name-String definitions*/
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>

#include "libuiP.h"

#include <stdio.h>
#include <string.h>
 
static dialDialogInfoRec dialogInfo;

static Widget dialDialog;
static Widget phone_field;

static void dialDialogCancel( Widget w, XtPointer p1, XtPointer p2 );
static void dialDialogOk( Widget w, XtPointer p1, XtPointer p2 );

void dialDialogCreate()
{
   Widget dialog_contents, w1, w2, ok, cancel, help;
   String myreturn;
   XtAccelerators accel;

   myreturn = "#override <Key>Return:   set() notify() unset()\n";
   accel    = XtParseAcceleratorTable(myreturn);    

   dialDialog = XtVaCreateManagedWidget(
      "numberDialog", 
      transientShellWidgetClass, __toplevel,
      XtNtitle,                  "Phone Number",
      NULL );
   
   dialog_contents = XtVaCreateManagedWidget( 
      "dialogContents",
      formWidgetClass,           dialDialog,
      NULL );
      

   w1 = XtVaCreateManagedWidget( 
      "dialogLabel",
      labelWidgetClass,          dialog_contents,
      XtNlabel,                  "Please enter phone number to dial:",
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNborderWidth,            0,
      NULL );
      
   w2 = XtVaCreateManagedWidget( 
      "numberLabel",
      labelWidgetClass,          dialog_contents,
      XtNlabel,                  "Number:",
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNborderWidth,            0,
      XtNfromVert,               w1,
      NULL );

   phone_field = XtVaCreateManagedWidget(
      "numberField",
      asciiTextWidgetClass,      dialog_contents,
    XtNfromHoriz,              w2,
      XtNfromVert,               w1,
      XtNeditType,               XawtextEdit,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   ok = XtVaCreateManagedWidget(
      "okButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Dial  ",
      XtNfromVert,               phone_field,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNaccelerators,           accel,
      NULL );

   cancel = XtVaCreateManagedWidget(
      "cancelButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Cancel  ",
      XtNfromVert,               phone_field,
      XtNfromHoriz,              ok,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   help = XtVaCreateManagedWidget(
      "helpButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Help  ",
      XtNfromVert,               phone_field,
      XtNfromHoriz,              cancel,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   XtAddCallback( cancel, XtNcallback, dialDialogCancel, 0 );
   XtAddCallback( ok,     XtNcallback, dialDialogOk,     0 );
   XtAddCallback( help,   XtNcallback, displayHelpCallback, DialHelpString );
   
   XtInstallAccelerators( phone_field, ok );
  
}

void dialDialogPopup()
{
   if( !XtIsManaged( dialDialog ) )
      XtManageChild( dialDialog );
   XtPopup( dialDialog, XtGrabNone );
}

void dialDialogPopdown()
{
   XtPopdown( dialDialog );
}

static void dialDialogCancel( Widget w, XtPointer p1, XtPointer p2 )
{
   XtPopdown( dialDialog );
   dialogInfo.cancelCallback();
}

static void dialDialogOk( Widget w, XtPointer p1, XtPointer p2 )
{
   static char number[100];
   String s;
   XtVaGetValues( phone_field, XtNstring, &s, NULL );
   if( strlen( s ) > 0 )
   {
      strcpy( number, s );
      XtPopdown( dialDialog );
      dialogInfo.dialCallback( number );
   }
}

void dialDialogInit( dialDialogInfoRec* info )
{
   dialogInfo.cancelCallback = info->cancelCallback;
   dialogInfo.dialCallback = info->dialCallback;

   if( info->number != NULL )
   {
      XtVaSetValues( phone_field, XtNstring, info->number, NULL );
      XtVaSetValues( phone_field, XtNinsertPosition, strlen( info->number) ,NULL );
   }
}

/*
 * EOF libui/xt/dialI.c
 */
