/*
 * $Id: dialingI.c,v 1.10 1998/02/17 09:52:58 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/xt/dialingI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Intrinsic.h>     /* Intrinsics Definitions*/
#include <X11/StringDefs.h>    /* Standard Name-String definitions*/
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include "libuiP.h"

static dialingDialogInfoRec dialogInfo;

static Widget dialingDialog;
static Widget number_field;
static Widget time_field;
static Widget attempt_field;
static time_t timer_counter;
static int    attempt = 0;
static XtIntervalId timeout = -1;

static void dialingDialogCancel( Widget w, XtPointer p1, XtPointer p2 );
static void dialingDialogRetry( Widget w, XtPointer p1, XtPointer p2 );

static void updateTime( XtPointer data, XtIntervalId* id );

void dialingDialogCreate()
{
   Widget dialog_contents, form, w1, w2, retry, cancel, help;
   dialogInfo.number = NULL;
   
   dialingDialog = XtVaCreateManagedWidget(
      "dialingDialog",
      transientShellWidgetClass, __toplevel,
      XtNtitle,                  "Dialing...",
      NULL );
   
   dialog_contents = XtVaCreateManagedWidget(
      "dialogContents",
      formWidgetClass,           dialingDialog,
      NULL );
   
   w1 = XtVaCreateManagedWidget(
      "dialogLabel",
      labelWidgetClass,          dialog_contents,
      XtNlabel,                  "Dial status:",
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNborderWidth,            0, 
      NULL );
   form = XtVaCreateManagedWidget(
      "infoForm",
      formWidgetClass,           dialog_contents,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNfromVert,               w1,
      NULL );
   w2 = XtVaCreateManagedWidget(
      "",
      formWidgetClass,           form,
      XtNborderWidth,            0,   
      NULL );
      
   w1 = XtVaCreateManagedWidget(
      "numberLabel",
      labelWidgetClass,          w2,
      XtNlabel,                  "Number:",
      XtNborderWidth,            0, 
      XtNjustify,                XtJustifyRight, 
      NULL );
   w1 = XtVaCreateManagedWidget(
      "timeLabel",
      labelWidgetClass,          w2,
      XtNlabel,                  "Time:",
      XtNborderWidth,            0, 
      XtNfromVert,               w1,
      XtNjustify,                XtJustifyRight, 
      NULL );
   w1 = XtVaCreateManagedWidget(
      "attemptLabel",
      labelWidgetClass,          w2,
      XtNlabel,                  "Attempt:",
      XtNborderWidth,            0, 
      XtNjustify,                XtJustifyRight, 
      XtNfromVert,               w1,
      NULL );
   w2 = XtVaCreateManagedWidget(
      "",
      formWidgetClass,           form,
      XtNborderWidth,            0,   
      XtNfromHoriz,              w2,
      NULL );

   number_field = XtVaCreateManagedWidget(
      "numberField",
      labelWidgetClass,          w2,
      XtNfromVert,               NULL,
      XtNjustify,                XtJustifyRight,
      XtNwidth,                  100,
      XtNborderWidth,            0,
      NULL );

   time_field = XtVaCreateManagedWidget(
      "timeField",
      labelWidgetClass,          w2,
      XtNfromVert,               number_field,
      XtNjustify,                XtJustifyRight,
      XtNwidth,                  100,
      XtNborderWidth,            0,
      NULL );
  attempt_field = XtVaCreateManagedWidget(
      "attemptField",
      labelWidgetClass,          w2,
      XtNfromVert,               time_field,
      XtNjustify,                XtJustifyRight, 
      XtNwidth,                  100,
      XtNborderWidth,            0,   
      NULL );


   retry = XtVaCreateManagedWidget(
      "retryButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Retry  ",
      XtNfromVert,               form,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );
   cancel = XtVaCreateManagedWidget(
      "cancelButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Cancel  ",   
      XtNfromVert,               form,    
      XtNfromHoriz,              retry,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );
                              
   help = XtVaCreateManagedWidget(
      "helpButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Help  ",
      XtNfromVert,               form,
      XtNfromHoriz,              cancel,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   XtAddCallback( cancel, XtNcallback, dialingDialogCancel, NULL );
   XtAddCallback( retry,  XtNcallback, dialingDialogRetry,  NULL );
   XtAddCallback( help,   XtNcallback, displayHelpCallback, DialingHelpString );
      
}

void dialingDialogPopup()
{
   if( !XtIsManaged( dialingDialog ) )
      XtManageChild( dialingDialog );
   XtPopup( ( dialingDialog ), XtGrabNone );
   attempt = 0;
   dialingDialogReset();
   updateTime( NULL, NULL );
   XtVaSetValues( number_field, XtNlabel, dialogInfo.number, NULL );
}

void dialingDialogPopdown()
{
   if( timeout != -1 )
      XtRemoveTimeOut( timeout );
   XtPopdown( ( dialingDialog ) );
}

void dialingDialogInit( dialingDialogInfoRec* info )
{
   dialogInfo.cancelCallback  = info->cancelCallback;
   dialogInfo.timeoutCallback = info->timeoutCallback;
   dialogInfo.retryCallback   = info->retryCallback;

   dialogInfo.timeout = info->timeout;
   if( dialogInfo.number != NULL )
      free( dialogInfo.number );
   dialogInfo.number = strdup( info->number );
}

static void dialingDialogCancel( Widget w, XtPointer p1, XtPointer p2 )
{
   XtPopdown( dialingDialog );
   dialogInfo.cancelCallback();
}

static void dialingDialogRetry( Widget w, XtPointer p1, XtPointer p2 )
{
   dialogInfo.retryCallback();
}



void dialingDialogReset()
{
   char buf[20];
   timer_counter = dialogInfo.timeout;
   attempt++;
   sprintf( buf, "%d", attempt );
   XtVaSetValues( attempt_field, XtNlabel, buf, NULL );
}

static void updateTime( XtPointer data, XtIntervalId* id )
{
   char buf[20];
   struct tm* tm;

   if( id != NULL )
      timer_counter--;
   if( timer_counter == 0 )
   {
      XtPopdown( dialingDialog );
      dialogInfo.timeoutCallback();
      return;
   }
         
   tm = gmtime( &timer_counter );
   strftime( buf, sizeof(buf), "%M:%S", tm );
   
   XtVaSetValues( time_field, XtNlabel, buf, NULL );
   timeout = XtAppAddTimeOut( AppContext, 1000, updateTime, NULL );
}

/*
 * EOF libui/xt/dialingI.c
 */
