/*
 * $Id: errorI.c,v 1.10 1998/02/17 09:52:59 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/xt/errorI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>    /* Standard Name-String definitions*/
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>    
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>   


#include "libuiP.h"

static Widget errorDialog;
static Widget dialogLabel;

static int errorDialogAnswer;

static void errorDialogResponse( Widget w, XtPointer p1, XtPointer p2 );

void errorDialogCreate()
{
   Widget dialog_contents, ok, help;

   errorDialog = XtVaCreateManagedWidget(
      "errorDialog", 
      transientShellWidgetClass, __toplevel,
      XtNtitle,                  "Error:",
      NULL );
   
   dialog_contents = XtVaCreateManagedWidget( 
      "dialogContents",
      formWidgetClass,           errorDialog,
      NULL );
      

   dialogLabel = XtVaCreateManagedWidget( 
      "dialogLabel",
      labelWidgetClass,          dialog_contents,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNborderWidth,            0,
      NULL );
      

   ok = XtVaCreateManagedWidget(
      "okButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Ok  ",
      XtNfromVert,               dialogLabel,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   help = XtVaCreateManagedWidget(
      "helpButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Help  ", 
      XtNfromVert,               dialogLabel,
      XtNfromHoriz,              ok, 
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   XtAddCallback( ok,   XtNcallback, errorDialogResponse, 0 );
   XtAddCallback( help, XtNcallback, displayHelpCallback, ErrorHelpString );

}

void errorDialogPopup( char* msg )
{
   errorDialogCreate( __toplevel );
   
   XtVaSetValues( dialogLabel, XtNlabel, msg, NULL );
   
   errorDialogAnswer = 0;
   XtManageChild( errorDialog );
   XtPopup( errorDialog, XtGrabNone );

   /* Process only X events and Timer events */
   while( errorDialogAnswer == 0 || 
          XtAppPending( AppContext ) & (XtIMXEvent | XtIMTimer) )
      XtAppProcessEvent( AppContext, XtIMXEvent | XtIMTimer );

   XtDestroyWidget( errorDialog );
}

void errorDialogPopdown()
{
   XtPopdown( errorDialog );
}

static void errorDialogResponse( Widget w, XtPointer p1, XtPointer p2 )
{
   errorDialogAnswer = 1;
}
/*
 * EOF libui/xt/errorI.c
 */
