/*
 * $Id: loginI.c,v 1.9 1998/02/17 09:53:01 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/xt/loginI.c,v $
 * $Revision: 1.9 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Intrinsic.h>     /* Intrinsics Definitions*/
#include <X11/StringDefs.h>    /* Standard Name-String definitions*/
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>  

#include "libuiP.h"

static Widget loginDialog;
static Widget user_field;
static Widget pw_field;

static loginDialogInfoRec dialogInfo;

static void loginDialogCancel( Widget w, XtPointer p1, XtPointer p2 );
static void loginDialogOk( Widget w, XtPointer p1, XtPointer p2 );

void loginDialogCreate()
{
   Widget dialog_contents, label, w1, ok, cancel, help, form1, form2;
   String myreturn = "#override <Key>Return:   set() notify() unset()\n";
   XtAccelerators accel;
   accel = XtParseAcceleratorTable(myreturn);

   loginDialog = XtVaCreateManagedWidget(
      "loginDialog", 
      transientShellWidgetClass, __toplevel,
      XtNtitle,                  "Login",
      NULL );
   
   dialog_contents = XtVaCreateManagedWidget(
      "dialogContents",
      formWidgetClass,           loginDialog,
      NULL );

   label = XtVaCreateManagedWidget(
      "dialogLabel",
      labelWidgetClass,          dialog_contents,
      XtNlabel,                  "Please enter user name and password:",
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNborderWidth,            0, 
      NULL );
   form1 = XtVaCreateManagedWidget(
      "",
      formWidgetClass,           dialog_contents,
      XtNborderWidth,            0,
      XtNfromVert,               label, 
      NULL );

   w1 = XtVaCreateManagedWidget(
      "userLabel",
      labelWidgetClass,          form1,
      XtNlabel,                  "User:",
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNborderWidth,            0, 
      NULL );

   w1 = XtVaCreateManagedWidget(
      "passwordLabel",
      labelWidgetClass,          form1,
      XtNlabel,                  "Password:",
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNborderWidth,            0, 
      XtNfromVert,               w1,
      NULL );

   form2 = XtVaCreateManagedWidget(
      "",
      formWidgetClass,           dialog_contents,
      XtNborderWidth,            0,
      XtNfromVert,               label, 
      XtNfromHoriz,              form1,
      NULL );

   user_field = XtVaCreateManagedWidget(
      "userField",
      asciiTextWidgetClass,      form2,
      XtNeditType,               XawtextEdit,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   pw_field = XtVaCreateManagedWidget(
      "passwordField",
      asciiTextWidgetClass,      form2,
      XtNfromVert,               user_field,
      XtNeditType,               XawtextEdit,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNecho,                   False,
      NULL );

   ok = XtVaCreateManagedWidget(
      "okButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Ok  ",
      XtNfromVert,               form1,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNaccelerators,           accel,
      NULL );

   cancel = XtVaCreateManagedWidget(
      "cancelButton",
      commandWidgetClass,       dialog_contents,
      XtNlabel,                  "  Cancel  ",   
      XtNfromVert,               form1,    
      XtNfromHoriz,              ok,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   help = XtVaCreateManagedWidget(
      "helpButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Help  ",
      XtNfromVert,               form1,
      XtNfromHoriz,              cancel,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   XtAddCallback( cancel, XtNcallback, loginDialogCancel, 0 );
   XtAddCallback( ok,     XtNcallback, loginDialogOk,     0 );
   XtAddCallback( help,   XtNcallback, displayHelpCallback, LoginHelpString );

   XtInstallAccelerators( user_field, ok );
   XtInstallAccelerators( pw_field, ok );

}

void loginDialogInit( loginDialogInfoRec* info )
{
   dialogInfo.cancelCallback = info->cancelCallback;
   dialogInfo.okCallback = info->okCallback;

   if( info->user != NULL )
   {
      XtVaSetValues( user_field, XtNstring, info->user, NULL );
      XtVaSetValues( user_field, XtNinsertPosition, strlen( info->user) , NULL );
   }
   if( info->pw != NULL )
   {
      XtVaSetValues( pw_field,   XtNstring, info->pw, NULL );
      XtVaSetValues( pw_field,   XtNinsertPosition, strlen( info->pw) , NULL );
   }
}
      
void loginDialogPopup()
{
   if( !XtIsManaged( loginDialog ) )
      XtManageChild( loginDialog );
   XtPopup( loginDialog, XtGrabNone );
}

void loginDialogPopdown()
{
   XtPopdown( loginDialog );
}


static void loginDialogCancel( Widget w, XtPointer p1, XtPointer p2 )
{
   XtPopdown( loginDialog );
   dialogInfo.cancelCallback();
}

static void loginDialogOk( Widget w, XtPointer p1, XtPointer p2 )
{
   static char  user[20];
   static char pw[20];
   String u, p;
   int u_l, p_l;
   
   XtVaGetValues( user_field, XtNstring, &u, NULL );
   XtVaGetValues( pw_field, XtNstring, &p, NULL );
   u_l = strlen( u );
   p_l = strlen( p );

   if( u_l == 0 )
      return;
   
   if( p_l == 0 )
   {
      return;
   }

   strncpy( user, u, sizeof(user));
   strncpy( pw,   p, sizeof(pw)  );

   XtPopdown( loginDialog );

   dialogInfo.okCallback( user, pw );  
}   

/*
 * EOF libui/xt/loginI.c
 */
