/*
 * $Id: loginMsgI.c,v 1.9 1998/02/17 09:53:01 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/xt/loginMsgI.c,v $
 * $Revision: 1.9 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Intrinsic.h>     /* Intrinsics Definitions*/
#include <X11/StringDefs.h>    /* Standard Name-String definitions*/
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>  
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>


#include <time.h>
#include <stdio.h>
#include <setjmp.h>

#include "libuiP.h"

static loginMsgDialogInfoRec dialogInfo;

static Widget loginMsgDialog;
static Widget user_field;
static Widget time_field;

static XtIntervalId timeout = -1;

static void loginMsgDialogCancel( Widget w, XtPointer p1, XtPointer p2 );
static void updateTime( XtPointer data, XtIntervalId* id );

void loginMsgDialogCreate()
{
   Widget dialog_contents, form, w1, w2, cancel, help;
   
   loginMsgDialog = XtVaCreateManagedWidget(
      "dialingDialog",
      transientShellWidgetClass, __toplevel,
      XtNtitle,                  "Dialing...",
      NULL );
   
   dialog_contents = XtVaCreateManagedWidget(
      "dialogContents",
      formWidgetClass,           loginMsgDialog,
      NULL );
   
   w1 = XtVaCreateManagedWidget(
      "dialogLabel",
      labelWidgetClass,          dialog_contents,
      XtNlabel,                  "Loging into the network:",
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNborderWidth,            0, 
      NULL );
   form = XtVaCreateManagedWidget(
      "infoForm",
      formWidgetClass,           dialog_contents,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      XtNfromVert,               w1,
      NULL );
   w2 = XtVaCreateManagedWidget(
      "",
      formWidgetClass,           form,
      XtNborderWidth,            0,   
      NULL );
      
   w1 = XtVaCreateManagedWidget(
      "userLabel",
      labelWidgetClass,          w2,
      XtNlabel,                  "User:",
      XtNborderWidth,            0, 
      XtNjustify,                XtJustifyRight, 
      NULL );
   w1 = XtVaCreateManagedWidget(
      "timeLabel",
      labelWidgetClass,          w2,
      XtNlabel,                  "Time:",
      XtNborderWidth,            0, 
      XtNfromVert,               w1,
      XtNjustify,                XtJustifyRight, 
      NULL );

   w2 = XtVaCreateManagedWidget(
      "",
      formWidgetClass,           form,
      XtNborderWidth,            0,   
      XtNfromHoriz,              w2,
      NULL );

   user_field = XtVaCreateManagedWidget(
      "userField",
      labelWidgetClass,          w2,
      XtNfromVert,               NULL,
      XtNjustify,                XtJustifyRight,
      XtNwidth,                  100,
      XtNborderWidth,            0,
      NULL );

   time_field = XtVaCreateManagedWidget(
      "timeField",
      labelWidgetClass,          w2,
      XtNfromVert,               user_field,
      XtNjustify,                XtJustifyLeft,
      XtNwidth,                  100,
      XtNborderWidth,            0,
      NULL );

   cancel = XtVaCreateManagedWidget(
      "cancelButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Cancel  ",   
      XtNfromVert,               form,    
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   help = XtVaCreateManagedWidget(
      "helpButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Help  ", 
      XtNfromVert,               form,
      XtNfromHoriz,              cancel, 
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   XtAddCallback( cancel, XtNcallback, loginMsgDialogCancel, NULL );
   XtAddCallback( help,   XtNcallback, displayHelpCallback, LoginMsgHelpString );
}

void loginMsgDialogPopup()
{
   if( !XtIsManaged( loginMsgDialog ) )
      XtManageChild( loginMsgDialog );
   XtPopup( loginMsgDialog, XtGrabNone );
   updateTime( NULL, NULL );
}

void loginMsgDialogPopdown()
{
   XtPopdown( loginMsgDialog );
   if( timeout != -1 )
      XtRemoveTimeOut( timeout );
   timeout = -1;

}

void loginMsgDialogInit( loginMsgDialogInfoRec* info )
{
   dialogInfo.cancelCallback = info->cancelCallback;
   dialogInfo.timeoutCallback = info->timeoutCallback;
   dialogInfo.timeout = info->timeout;
   XtVaSetValues( user_field, XtNlabel, info->user, NULL );
   timeout = -1;
}

static void loginMsgDialogCancel( Widget w, XtPointer p1, XtPointer p2 )
{
   XtPopdown( loginMsgDialog );
   dialogInfo.cancelCallback();
}


static void updateTime( XtPointer data, XtIntervalId* id )
{
   char buf[20];
   struct tm* tm;

   if( id != NULL )
      dialogInfo.timeout--;
   if( dialogInfo.timeout == 0 )
   {
      XtPopdown( loginMsgDialog );
      dialogInfo.timeoutCallback();
      return;
   }
         
   tm = gmtime( &dialogInfo.timeout );
   strftime( buf, sizeof(buf), "%M:%S", tm );
   
   XtVaSetValues( time_field, XtNlabel, buf, NULL );

   timeout = XtAppAddTimeOut( AppContext, 1000, updateTime, NULL );
}

/*
 * EOF libui/xt/loginMsgI.c
 */
