/*
 * $Id: statusI.c,v 1.10 1998/02/17 09:53:02 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/xt/statusI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Intrinsic.h>     /* Intrinsics Definitions*/
#include <X11/StringDefs.h>    /* Standard Name-String definitions*/
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Command.h>

#include <stdio.h>
#include <time.h>
#include <fcntl.h>

#include "libuiP.h"

#define XtNledColor       "ledColor"
#define XtCledColor       "LedColor"
#define XtledDefaultColor "green"

typedef struct
{
   Pixel color_1;
   Pixel color_2;
} AppData;
static AppData appData;

static XtResource resources[] =
{
   {
      XtNledColor, XtCledColor, XtRPixel, sizeof(Pixel),
      XtOffsetOf( AppData, color_2), XtRString, XtledDefaultColor
   }
};

#define _READ_START 1
#define _READ_STOP  0

const int _READ_TIMEOUT = 500;
const int _TIMER_COUNT = 250;


#define INPUT_DONE      0x00
#define INPUT_STOPPED   0x01
#define INPUT_STARTED   0x02
#define INPUT_WORKING   0x04

typedef struct
{
   int         fd;
   int         status;
   unsigned    long bytes;
   XtInputId   input;
} inputRec;

static inputRec input[2];

static statusDialogInfoRec dialogInfo;

static Widget  statusDialog,
               dialog_contents,
               led_read,
               led_write,
               bytes_read,
               bytes_write,
               connect_val,
               time_val;

static XtIntervalId connect_time = -1;

static Pixel colors[2];

static void startInput( XtPointer clientData, int* fd, XtInputId* id );
static void showBytes();
static void updateTime( XtPointer data, XtIntervalId* id );
static void statusDialogDisconnect( Widget, XtPointer, XtPointer );
static void setIndicator( int fd, int startRead );
static void doColors();

void statusDialogPopup()
{
   if( !XtIsManaged( statusDialog ) )
      XtManageChild( statusDialog );
   input[0].input = XtAppAddInput( AppContext, input[0].fd, 
            (XtPointer)XtInputReadMask,
            startInput,
            NULL );
   input[1].input = XtAppAddInput( AppContext, input[1].fd,
            (XtPointer)XtInputReadMask,
            startInput,
            NULL );
   input[0].status = input[1].status = INPUT_DONE;
   
   connect_time = XtAppAddTimeOut( AppContext, _TIMER_COUNT, updateTime, NULL );

   XtPopup( ( statusDialog ), XtGrabNone );
}

void statusDialogPopdown()
{
   XtRemoveInput( input[0].input );
   XtRemoveInput( input[1].input );
   if( connect_time != -1 )
      XtRemoveTimeOut( connect_time );
   XtPopdown( ( statusDialog ) );
}
   
void statusDialogCreate()
{
   Widget form1,
          form2,
          form3,
          w1, w2,
          disconnect, help;
   int n;
   
   statusDialog = XtVaCreateManagedWidget(
      "dialingDialog",
      transientShellWidgetClass, __toplevel,
      XtNtitle,                  "Connected",
      NULL );
   
   dialog_contents = XtVaCreateManagedWidget(
      "dialogContents",
      formWidgetClass,           statusDialog,
      NULL );

   form1 = XtVaCreateManagedWidget(
      "",
      formWidgetClass,           dialog_contents,
      XtNborderWidth,            0,
      NULL );

   led_read = XtVaCreateManagedWidget(
      "ledRead",
      formWidgetClass,           form1,
      XtNwidth,                  20,
      NULL );
   led_write = XtVaCreateManagedWidget(
      "ledWrite",
      formWidgetClass,           form1,
      XtNwidth,                  20,
      XtNfromVert,               led_read,
      NULL );

   form2 = XtVaCreateManagedWidget(
      "infoForm",
      formWidgetClass,           dialog_contents,
      XtNfromHoriz,                  form1,
      NULL );
   w1 = XtVaCreateManagedWidget(
      "",
      formWidgetClass,           form2,
      XtNborderWidth,            0,
      NULL );
   w2 = XtVaCreateManagedWidget(
      "",
      labelWidgetClass,          w1,
      XtNborderWidth,            0,
      XtNlabel,                  "Received:",
      XtNjustify,                XtJustifyLeft, 
      NULL );
   w2 = XtVaCreateManagedWidget(
      "",
      labelWidgetClass,          w1,
      XtNlabel,                  "Sent:",
      XtNborderWidth,            0,
      XtNfromVert,               w2,
      XtNjustify,                XtJustifyLeft, 
      NULL );

   w1 = XtVaCreateManagedWidget(
      "",
      formWidgetClass,           form2,
      XtNborderWidth,            0,
      XtNfromHoriz,              w1,
      NULL );
   bytes_read = XtVaCreateManagedWidget(
      "",
      labelWidgetClass,      w1,
      XtNborderWidth,            0,
      XtNlabel,                  "0",
      XtNjustify,                XtJustifyRight,
      XtNwidth,                  60,
      NULL );
   bytes_write = XtVaCreateManagedWidget(
      "",
      labelWidgetClass,      w1,
      XtNlabel,                  "0",
      XtNborderWidth,            0,
      XtNfromVert,               bytes_read,
      XtNjustify,                XtJustifyRight,
      XtNwidth,                  60,
      NULL );

   XtVaGetValues( bytes_read, XtNheight, &n, NULL );
   XtVaSetValues( led_read, XtNheight, n, NULL );
   XtVaSetValues( led_write, XtNheight, n, NULL );



   form3 = XtVaCreateManagedWidget(
      "infoForm",
      formWidgetClass,           dialog_contents,
      XtNfromHoriz,              form2,
      NULL );

   w1 = XtVaCreateManagedWidget(
      "",
      formWidgetClass,           form3,
      XtNborderWidth,            0,
      NULL );
   w2 = XtVaCreateManagedWidget(
      "",
      labelWidgetClass,          w1,
      XtNborderWidth,            0,
      XtNlabel,                  "Connect:",
      NULL );
   w2 = XtVaCreateManagedWidget(
      "",
      labelWidgetClass,          w1,
      XtNlabel,                  "Time:",
      XtNborderWidth,            0,
      XtNfromVert,               w2,
      NULL );

   w1 = XtVaCreateManagedWidget(
      "",
      formWidgetClass,           form3,
      XtNborderWidth,            0,
      XtNfromHoriz,              w1,
      NULL );
   connect_val = XtVaCreateManagedWidget(
      "",
      labelWidgetClass,          w1,
      XtNlabel,                  "28800 bps",
      XtNborderWidth,            0,
      NULL );
   time_val = XtVaCreateManagedWidget(
      "",
      labelWidgetClass,          w1,
      XtNlabel,                  "00:00:53",
      XtNborderWidth,            0,
      XtNfromVert,               connect_val,
      NULL );

   disconnect = XtVaCreateManagedWidget(   
      "disconnectButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Disconnect  ",
      XtNfromVert,               form1,
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );

   help = XtVaCreateManagedWidget(
      "helpButton",
      commandWidgetClass,        dialog_contents,
      XtNlabel,                  "  Help  ", 
      XtNfromVert,               form1,
      XtNfromHoriz,              disconnect, 
      XtNvertDistance,           20,
      XtNhorizDistance,          20,
      NULL );
   
   XtAddCallback( disconnect, XtNcallback, statusDialogDisconnect, NULL );
   XtAddCallback( help,   XtNcallback, displayHelpCallback, StatusHelpString );
      
   doColors();
   XtVaSetValues( led_read, XtNbackground, colors[0], NULL );
   XtVaSetValues( led_write, XtNbackground, colors[0], NULL );
      
}

static void doColors()
{
   XtGetApplicationResources( statusDialog,
      &appData,
      resources, XtNumber( resources ),
      NULL, 0 );
   colors[1] = appData.color_2;   
   XtVaGetValues( dialog_contents, XtNbackground, &colors[0], NULL );
}
   
static void statusDialogDisconnect( Widget w, XtPointer p1, XtPointer p2 )
{
   XtPopdown( ( statusDialog ) );
   dialogInfo.disconnectCallback();
}

void statusDialogInit( statusDialogInfoRec* info )
{
   char buf[100];
   input[0].fd = info->fd1;
   input[1].fd = info->fd2;
   dialogInfo.readCallback = info->readCallback;
   dialogInfo.timeCallback = info->timeCallback;
   dialogInfo.disconnectCallback = info->disconnectCallback;

   sprintf( buf, "%s bps", info->connectSpeed );
   XtVaSetValues( connect_val, XtNlabel, buf, NULL );

   sprintf( buf, "Connected to %s", info->connectedTo );
   XtVaSetValues( statusDialog, XtNtitle, buf, NULL );
      
   input[0].bytes = input[1].bytes = 0;
}


static void updateTime( XtPointer data, XtIntervalId* id )
{
   time_t time;
   static int fract = 1;
   char buf[100];
   struct tm* tm;
   int i;
   int show_bytes = 0;

   connect_time = XtAppAddTimeOut( AppContext, _TIMER_COUNT, updateTime, NULL );
   
   if( fract * _TIMER_COUNT >= 1000 )
   {
      time = dialogInfo.timeCallback();
      tm = gmtime( &time );
      strftime( buf, sizeof(buf), "%H:%M:%S", tm );
      XtVaSetValues( time_val, XtNlabel, buf, NULL );
      fract = 1;
   }
   else
      fract++;

   for( i = 0; i<2; i++ )
   switch( input[i].status )
   {
      case INPUT_STOPPED:
         setIndicator( input[i].fd, _READ_STOP );
         input[i].status = INPUT_DONE;
         break;
      case INPUT_WORKING:
         show_bytes = 1;
      case INPUT_STARTED:
         input[i].status = INPUT_STOPPED;
         break;
   }

   if( show_bytes )
      showBytes();
}   
   
static void setIndicator( int fd, int startRead )
{
   Widget w;

   if( fd == input[0].fd )
      w = led_read;
   else
   if( fd == input[1].fd )
      w = led_write;
   else
      return;

   XtVaSetValues( w, XtNbackground, colors[startRead], NULL );
}

static void startInput( XtPointer clientData, int* fd, XtInputId* id )
{
   int result;
   int i;
   
   if( *id == input[0].input )
      i = 0;
   else
      i = 1;

   
   if( input[i].status == INPUT_DONE  )
   {
      input[i].status = INPUT_STARTED;
      setIndicator( input[i].fd, _READ_START );
   }
   else
      input[i].status = INPUT_WORKING;

   result = dialogInfo.readCallback( input[i].fd );

   if( result > 0 )
      input[i].bytes += result;
   else
   if( result == 0 )
      XtRemoveInput( input[i].input ); 
   if( input[i].status == INPUT_STARTED )
      showBytes();
}


static void showBytes()
{
   char buf[100];

   if( input[0].status != INPUT_DONE )
   {
      sprintf( buf, "%ld", input[0].bytes );
      XtVaSetValues( bytes_read, XtNlabel, buf, NULL );
   }
   if( input[1].status != INPUT_DONE )
   {
      sprintf( buf, "%ld", input[1].bytes );
      XtVaSetValues( bytes_write, XtNlabel, buf, NULL );
   }
}


/*
 * EOF libui/xt/statusI.c
 */
