/*
 *
 * $Id: modem_defs.h,v 1.26 1998/02/17 09:51:50 mdejonge Exp $
 *   $Source: /home/mdejonge/CVS/projects/modem/modem_defs.h,v $
 * $Revision: 1.26 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef _modem_defs_h
#define _modem_defs_h

/* Section Communication*/
#define TCP_DEFAULT_PORT      12345
#define TCP_SERVICE           "modemd"
#define UDP_DEFAULT_PORT      12345
#define UDP_SERVICE           "modemd"
#define MODEM_SERVER          "localhost"
#define SERVER_TIMEOUT        5
#define CLIENT_TIMEOUT        5

/* Section Server */
#define MODEMD_CONFIG_FILE    "/etc/modemd.conf"
#define SERVER_DIR            "/var/adm/modemd/"           /* * */
#define ACCESS_LOG_FILE       "./access.log"               /* * */
#define ERROR_LOG_FILE        "./error.log"                /* * */
#define ACCOUNT_LOG_FILE      "./account.log"              /* * */
#define SERVER_LOCK_FILE      "./modemd.pid"               /* * */
#define VERIFY_USER           SBINDIR ## "/verify_user"    /* * */
#define VERIFY_NUMBER         SBINDIR ## "/verify_number"  /* * */
#define SERVER_UMASK          0117                         /* * */

/* Section Modem */
#define MODEM_CONFIG_FILE     "/etc/modems.conf"           /* * */
#define MODEM_COMMANDS        DATADIR ## "/modem_commands" /* * */
#define MODEM_ENV_VAR         "MODEM"
#define DEF_MODEM_TYPE        "hayes"
#define ATTN                  "+++"
#define RSET                  "ATZ"
#define INIT                  "ATE0 Q0 V1 X4"
#define DIAL                  "ATD"
#define HANGUP                "ATH"

/* Section Modem locking: */
#define _PATH_LOCKD           "/var/spool/locks/"
#define _UID_UUCP             "uucp"

/* Section Personal settings: */
#define PHONEBOOK             "~/.phonebook"

/* Section help: */
#define HELP_URL              "file:/usr/local/share/modem"

/* When help files are stored on www server, let HELP_URL
 * to it. For example:
 * #define HELP_URL              "http://hostname/location"
 */
#endif

/*
 * EOF modem_defs.h
 */
