/*
 * $Id: jobc.c,v 1.9 1998/02/17 09:53:05 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/modemcontrol/jobc.c,v $
 * $Revision: 1.9 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <signal.h>

#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <liberror/liberror.h>
#include <libport/libport.h>
#include <libtty/libtty.h>

#include "jobc.h"
#include <errno.h>
#include "modem_defs.h"

#define ARG_SIZE   20

static pid_t pid = -1;

/*
 * Build array of arguments from string.
 * command: command string 
 * argv:    array to store arguments 
 * argc:    size of argv
 */
static int buildCommand( int argc, char* argv[], char* command )
{
   int i;
   char* ptr;
   ptr = strdup(command);
   i = 0;
   
   while( *ptr && i < argc )
   {
      while( (*ptr == ' ' ) || (*ptr == '\t' ) )
         *ptr++ = '\0';
      argv[i++] = ptr;
      
      while( (*ptr != '\0' ) && (*ptr != ' ') && (*ptr != '\t' ) )
         ptr++;
   }
   argv[i] = NULL;
   return 0;
}

/*
 * Create new job
 */
int jobControlNewJob( char* command, char* ptySlaveDevName )
{
   char* argv[ARG_SIZE];
   int   ptySlaveDev;
   int   i;
   
   /* Build array of arguments from command */
   if( buildCommand( ARG_SIZE, argv, command ) < 0 )
      return -1;

   /* Open pseudo terminal */
   ptySlaveDev = openPtySlave( ptySlaveDevName );
   if( ptySlaveDev == -1 )
   {
      FAIL( "openPtySlave" );
      exit( 1 ); 
   }

   /* fork */
   pid = fork();
   switch( pid )
   {
      case 0:
         if( setsid() == -1 )
	 {
	    FAIL( "setsid" );
	    exit( 1 );
	 }

         if( ttySetRaw( ptySlaveDev ) == -1 )
         {
            close( ptySlaveDev );
            FAIL( "ttySetRaw" );
            exit( 1 );
         }
         /*
          * Close all file descripters except STDIN_FILENO,
          * STDOUT_FILENO, STDERR_FILENO and ptySlaveDev.
          */
         for( i = 0; i < sysconf( _SC_OPEN_MAX ); i++ )
         {
            if( i !=  STDIN_FILENO &&
                i != STDOUT_FILENO &&
                i != STDERR_FILENO &&
                i != ptySlaveDev )
               close( i );
         }

         /*
          * slave becomes modem device 
          * set environment variable to this new
          * modem device 
          */
         setenv( MODEM_ENV_VAR, ptySlaveDevName, 1 );
         /* execute command */
         execvp( argv[0], argv );
         FAIL1( "execvp", argv[0] );
         exit( 1 );
      case -1:
         FAIL( "fork" );
         exit( 1 );
      default:
         return pid;
   }
}


/*
 * Kill jobs
 */
void jobControlKillJobs()
{   
   /* 
    * Send SIGTERM to all processes in process group of
    * process with id pid.
    */
   if( pid != -1 )
   {
      kill( -pid, SIGTERM );
   }
}

/*
 * Signal handler
 *
 * Catch SIGCHLD
 */
static void jobControlSignalHandler( int sig )
{
   pid_t dead_pid;
   int status;

   switch( sig )
   {
      /*
       * Exit when child dies
       */
      case SIGCHLD:
         if( pid != -1 )
         {
            TEMP_FAILURE_RETRY( dead_pid,
               waitpid( pid, &status, WNOHANG | WUNTRACED ) );

            if( dead_pid == pid )
            {
               exit( 0 );
            } 
            else
            if( dead_pid == -1 )
            {
               FAIL( "waitpid" );
               exit( 1 );
            }
         }
   }
}

/*
 * Initialize jobcontrol 
 */
void jobControlInit()
{
   struct sigaction act;
   /* Install signal handler */
   sigemptyset( &act.sa_mask );
   act.sa_handler = jobControlSignalHandler;
#ifdef SA_RESTART
   act.sa_flags   = SA_RESTART;
#endif
   sigaction( SIGCHLD, &act, NULL );
}

/*
 * EOF modemcontrol/jobc.c
 */
