/*
 * $Id: auth.c,v 1.13 1998/02/17 09:53:08 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/modemd/auth.c,v $
 * $Revision: 1.13 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>

#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#include <stdio.h>

#include <liberror/liberror.h>
#include <libprotocol/libprotocol.h>
#include <libtcpip/libtcpip.h>
#include <libport/libport.h>
#include <modem_defs.h>

#include "modemd.h"   
#include "request.h"
#include "syscmd.h"
#include "auth.h"
#include "configuration.h"

#ifndef WEXITSTATUS
#define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8 )
#endif

#ifndef WIFEXITED
#define WIFEXITED(stat_val) (((stat_val) & 256) == 0 )
#endif

static int verify_user( const char* host,  const char* uname );

/*
 * Create new request for new client
 */
void new_request( sockStruct* sock )
{
   sockStruct client;
   int nbytes;
   int dummy;
   request* req;

   req = requestNew();

   if( req == NULL )  
      return;

   /* Read dummy message from client */
   nbytes = sockRecv( sock, &client, &dummy, sizeof( dummy ) );
   if( nbytes < 0 )
   {
      FAIL( "sockRecv" );
      exit( 1 );
   }
      
   /* Send request to client */
   nbytes = sockSend( &client, req, sizeof( request ) );
   if( nbytes < 0 )
   {
      FAIL( "sockSend" );
      /* No exit, because this should not crash the modemd server !! */   
   }
   return;
}

/*
 * Check whether the client has received our request.
 *
 */
void check_client( int fd, const char* host, const char* name )
{
   request req;
   int result;

   char* err_msg = "Go away\n";
   
   /* Read request from client */
   TEMP_FAILURE_RETRY( result, read( fd, &req, sizeof( req ) ) );
   if( result < 0 )
   {
      FAIL( "read" );
      exit( 1 );
   }

   /* Lookup the list for the request */
   if( requestListLookup( req ) == -1 )
   {
      TEMP_FAILURE_RETRY( result,
                         write( fd, err_msg, strlen( err_msg ) + 1 ) );
      if( result < 0 )
      {
         FAIL( "write" );
         exit( 1 );
      }
      exit( 1 );
   }

   requestListRemove( req );

   if( strcmp( name, FROM_UNKNOWN) == 0 ||
       verify_user( host, name ) != 0 )
   {
      /* 
       * User does not have permission to use a modem
       * on this server.
       */
      if( protRequestConfirm( fd, PROT_REQUEST_FAILED ) < 0 )
      {
         FAIL( "protRequestConfirm" );
         exit( 1 );
      }
      FAIL( "verify_user" );
      exit( 1 );
   }
}

/*
 * Verify user.  
 * This function executes the program VERIFY_USER as defined in
 * modem_defs.h (and in configuration file as: verify_user). This
 * program (or script) which can be site specific should determine
 * whether or not the user is allowed to use a modem
 *
 * return:
 *  >0 on failure, the user does not have permission
 *  0 on success, The user does have permission.
 */
static int verify_user( const char* host,  const char* uname )
{
   int retval;
   /*
    * Execute VERIFY_USER script
    */
   retval = sys_cmd( get_verify_user(), uname, host, NULL );
   if( retval == -1 )
   {
      FAIL1( "sys_cmd", get_verify_user() );
      exit( 1 );
   }

   if( WIFEXITED( retval ) )
      return  WEXITSTATUS( retval );
   return 1;
} 
/*
 * EOF modemd/auth.c
 */
