/*
 * $Id: configuration.c,v 1.3 1998/02/17 09:53:09 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/modemd/configuration.c,v $
 * $Revision: 1.3 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <string.h>

#include <libconf/libconf.h>
#include <liberror/liberror.h>
#include <modem_defs.h>
#include "configuration.h"

/* initialize data using compiled in default values */
static char* _server_dir        = SERVER_DIR;
static char* _access_log_file   = ACCESS_LOG_FILE;
static char* _error_log_file    = ERROR_LOG_FILE;
static char* _account_log_file  = ACCOUNT_LOG_FILE;
static char* _server_lock_file  = SERVER_LOCK_FILE;
static char* _verify_user       = VERIFY_USER;
static char* _verify_number     = VERIFY_NUMBER;
static int   _server_umask      = SERVER_UMASK;
static char* _modem_config_file = MODEM_CONFIG_FILE;
static char* _modem_commands    = MODEM_COMMANDS;

int init_configuration()
{
   conf_file* cf;
   
   /* try to open configurationfile */
   cf = open_conf( MODEMD_CONFIG_FILE );

   /* Open failed. We will use compiled in default values */
   if( cf == NULL )
      return -1;   

   _server_dir = 
      strdup( get_str( cf, "server", "server_dir", _server_dir ) );
   _access_log_file = 
      strdup( get_str( cf, "server", "access_log_file", _access_log_file ) );
   _error_log_file = 
      strdup( get_str( cf, "server", "error_log_file", _error_log_file ) );
   _account_log_file = 
      strdup( get_str( cf, "server", "account_log_file", _account_log_file ) );
   _server_lock_file = 
      strdup( get_str( cf, "server", "server_lock_file", _server_lock_file ) );
   _verify_user = 
      strdup( get_str( cf, "server", "verify_user", _verify_user ) );
   _verify_number = 
      strdup( get_str( cf, "server", "verify_number", _verify_number ) );
   _server_umask =
      get_int( cf, "server", "server_umask", _server_umask );

   _modem_config_file = 
      strdup( get_str( cf, "modem", "modem_config_file", _modem_config_file ) );
   _modem_commands = 
      strdup( get_str( cf, "modem", "modem_commands", _modem_commands ) );
   
   close_conf( cf );
   return 0;
}


/* Location where modemd server chdirs and runs */
const char* get_server_dir()
{
   return _server_dir;
}

/* Path name to file to which access logs are written. Path name can
 * be relative to server_dir.
 */
const char* get_access_log_file()
{
   return _access_log_file;
}

/* Path name to file to which error logs are written. Path name can
 * be relative to server_dir.
 */
const char* get_error_log_file()
{
   return _error_log_file;
}

/* Path name to file to which account logs are written. Path name can
 * be relative to server_dir.
 */
const char* get_account_log_file()
{
   return _account_log_file;
}

/* Path name to file that serves as lock file. The server process id
 * will be written to this file. Path name can be relative to
 * server_dir.
 */
const char* get_server_lock_file()
{
   return _server_lock_file;
}

/* Path name to program that verifies users permission to use modem
 * software. Path name can be relative to server_dir.
 */
const char* get_verify_user()
{
   return _verify_user;
}

/* Path name to program that verifies users permission to dial
 * desired number.  Path name can be relative to server_dir.
 */
const char* get_verify_number()
{
   return _verify_number;
}

/* Umask settings for modemd server process */
int get_server_umask()
{
   return _server_umask;
}

/* Path name of configuration file in which terminal settings for
 * modem devices are stored. Path name can be relative to sever_dir.
 */
const char* get_modem_config_file()
{
   return _modem_config_file;
}

/* Path name of configuration file in which command settings for
 * different types of modems are stored. Path name can be relative to
 * server_dir.
 */
const char* get_modem_commands()
{
   return _modem_commands;
}

/* EOF modemd/configuration.c */
