/*
 * $Id: configuration.h,v 1.3 1998/02/17 09:53:10 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/modemd/configuration.h,v $
 * $Revision: 1.3 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef configuration_h
#define configuration_h
/*
 * This file provides functions to retrieve items that can be
 * configured using the modemd configuration file (defined in
 * ../modem_defs.h).  Before data can be retrieved the function
 * "init_configuration" should be called that reads the information
 * from the configuration file.
 */

/* Read configuration data from configuration file. Must be called
 * before retrieving information using the functions defined below.
 */
int init_configuration();

/* Location where modemd server chdirs and runs */
const char* get_server_dir();

/* Path name to file to which access logs are written. Path name can
 * be relative to server_dir.
 */
const char* get_access_log_file();

/* Path name to file to which error logs are written. Path name can
 * be relative to server_dir.
 */
const char* get_error_log_file();

/* Path name to file to which account logs are written. Path name can
 * be relative to server_dir.
 */
const char* get_account_log_file();

/* Path name to file that serves as lock file. The server process id
 * will be written to this file. Path name can be relative to
 * server_dir.
 */
const char* get_server_lock_file();

/* Path name to program that verifies users permission to use modem
 * software. Path name can be relative to server_dir.
 */
const char* get_verify_user();

/* Path name to program that verifies users permission to dial
 * desired number.  Path name can be relative to server_dir.
 */
const char* get_verify_number();

/* Umask settings for modemd server process */
int get_server_umask();

/* Path name of configuration file in which terminal settings for
 * modem devices are stored. Path name can be relative to sever_dir.
 */
const char* get_modem_config_file();

/* Path name of configuration file in which command settings for
 * different types of modems are stored. Path name can be relative to
 * server_dir.
 */
const char* get_modem_commands();

#endif /* configuration_h */

/* EOF modemd/configuration.h */
