/*
 * $Id: log.c,v 1.11 1998/02/17 09:53:12 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/modemd/log.c,v $
 * $Revision: 1.11 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>

#include <modem_defs.h>
#include <liberror/liberror.h>
#include "log.h"
#include "configuration.h"

/* Default action is to write log to stderr */
FILE* ERR_LOG     = stderr;
FILE* ACCESS_LOG  = stderr;
FILE* ACCOUNT_LOG = stderr;

static int daemonMode = 0;
static int logStarted = 0;
/*
 * Start the log.
 * when daemon = 1, all messages are written to files,
 * when daemon = 0, all messages are written to stderr
 */ 
int startLog( int daemon )
{
   daemonMode = daemon;
   
   if( daemonMode )
   {
      /* Open error logfile */
      ERR_LOG = freopen( get_error_log_file(), "a+", stderr );
      if( ERR_LOG == NULL )
      {
         /* restore to previous stream */
         ERR_LOG = stderr;
         FAIL1( "open", get_error_log_file() );
         exit( 1 );
      }
      /* Open access logfile */
      ACCESS_LOG = fopen( get_access_log_file(), "a+" );
      if( ACCESS_LOG == NULL )
      {
         /* restore to previous stream */
         ACCESS_LOG = stderr;
         FAIL1( "open", get_access_log_file() );
         exit( 1 );
      }
      /* Open account logfile */
      ACCOUNT_LOG = fopen( get_account_log_file(), "a+" );
      if( ACCOUNT_LOG == NULL )
      {
         /* restore to previous stream */
         ACCOUNT_LOG = stderr;
         FAIL1( "open", get_account_log_file() );
         exit( 1 );
      }

      /* explicitly flush the streams... */ 
      if( fflush( ERR_LOG )     == EOF ||
          fflush( ACCESS_LOG )  == EOF ||
          fflush( ACCOUNT_LOG ) == EOF )                
      {                                                
         FAIL( "fflush" );                             
         exit( 1 );                                    
      }
      
      /* ... and set to unbuffered output */                                                 
      if( setvbuf( ERR_LOG,     NULL, _IONBF, 0 ) != 0 ||  
          setvbuf( ACCESS_LOG,  NULL, _IONBF, 0 ) != 0 ||
          setvbuf( ACCOUNT_LOG, NULL, _IONBF, 0 ) != 0 )
      {
         FAIL( "setvbuf" );
         exit( 1 );
      }
   }
   else
   {
      /* Daemon = 0. All logs are written to stderr */
      ERR_LOG     = stderr;
      ACCESS_LOG  = stderr;
      ACCOUNT_LOG = stderr;
   }
   atexit( closeLog );
   logStarted = 1;
   return 0;
}

/* 
 * Close the log
 */
void closeLog()
{
   if( !logStarted )
      return;

   /* Close all logfiles */
   if( daemonMode )
   {
      if( fclose( ERR_LOG )     == EOF ||
          fclose( ACCESS_LOG )  == EOF ||
          fclose( ACCOUNT_LOG ) == EOF )
      {
         FAIL( "close" );
         exit( 1 );
      }      
   }
   logStarted = 0;
}

/*
 * EOF modemd/log.c
 */
