.\"
.\" $Id: modem_commands.man,v 1.7 1998/02/17 09:53:14 mdejonge Exp $
.\"
.\"   $Source: /home/mdejonge/CVS/projects/modem/modemd/modem_commands.man,v $
.\" $Revision: 1.7 $
.\"    Author: Merijn de Jonge
.\"     Email: mdejonge@wins.uva.nl
.\" 
.\"  
.\" 
.\" This file is part of the modem communication package.
.\" Copyright (C) 1996-1998  Merijn de Jonge
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\" 
.\"
.TH modem_commands 5 "Jan 16, 1997"
.SH NAME
/usr/local/lib/modem_commands \- configuration file for modems

.SH DESCRIPTION 
The \fImodem_commands\fP file is used to configure the command set
for different types of modems. It is accessed by modemd(1) to
retrieve the correct command string to send to a particular modem
device according to each type. The configuration file
contains a section for each modem type.

In modems.conf(5), each modem device that is controlled by modemd(1)
is mapped to a modem type (the \fBtype\fP key). When modemd(1) needs
to send a command to the modem of a specified type (for example
\fBHAYES\fP), it searches \fImodem_commands\fP to find a section according
to the type of the modem. When such a section exists and in that
section the desired command is defined, modemd(1) uses that string
to send to the modem. In all other cases a default string is used as
command to send to the modem. The default command set is defined at
compile time and is \fBHAYES\fP compatible. 


The global structure of the configuration file  is  as  follows:

[type_1]
   key_1 = value_1
   key_2 = value_2
   .
   .

[type_2]
   key_1 = value_1
   key_2 = value_2
   .
   .

A `#' indicates the beginning of a comment. Comments continues 
until the end of the line. The name of each command set is used as
section name in the configuration file. For example, when in
modes.conf(5) a type definition is given for a modem device:
   `type = hayes'
.P
then a section named `hayes' defines the command set that is used for
that modem. Currently the following keys are defined:
.TP 8
.B attn
String used to put modem in Command Mode. Default value: "+++"
.TP 8
.B rset
String used to reset modem. Default value: "ATE0 Q0 V1 X4"
.TP 8
.B dial
String used to start dialing. Default value: "ATD"
.TP 8
.B hangup
String used to hang up the modem. Default value: "ATH"
.P
All key/value pairs are optional, when not defined the default
commands are used as defined at compile time. The items above are the
items used by the program. Other items can be defined but they are
just ignored. The default values are defined at compile time and may
differ due to special configuration.

.SH NOTES
Because missing commands are taken from the default command set, you
only need to specify those commands that are different from the
default (\fBHAYES\fP compatible) command set.

.SH SEE ALSO
.BR modemd "(1), 
.BR modems.conf "(5)

.SH AUTHOR
Merijn de Jonge (mdejonge@wins.uva.nl)
.\"
.\" EOF modemd/modem_commands.man
.\"
