.\"
.\" $Id: modemd.conf.man,v 1.5 1998/02/17 09:53:15 mdejonge Exp $
.\"
.\"   $Source: /home/mdejonge/CVS/projects/modem/modemd/modemd.conf.man,v $
.\" $Revision: 1.5 $
.\"    Author: Merijn de Jonge
.\"     Email: mdejonge@wins.uva.nl
.\" 
.\"  
.\" 
.\" This file is part of the modem communication package.
.\" Copyright (C) 1996-1998  Merijn de Jonge
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\" 
.\"
.TH modemd.conf 5 "Nov 13, 1997"
.SH NAME
/etc/modemd.conf \- configuration file for modemd server

.SH DESCRIPTION 

The \fImodemd.conf\fP file is used by the modem server (see
modemd(1)). The configuration file contains two sections. The first
section (\fIserver\fP) contains items that configure part of the
modemd server. Among others, this section specifies several
directories and path names to files used by the server (see below for
a complete description of all recognized items). The second section
(\fImodem\fP) contains items that configure the locations of files
that contain configuration information of modem devices (see
\fImodems.conf\fP(5)) and modem command sets (see
\fImodem_commands\fP(5)). The \fImodemd.conf\fP configuration file is
optional. When the file does not exist, default values defined at
compile time are used instead (see installation instructions for
details about setting default values). All items in the configuration
file are optional as well. When available, they overrule the default
values defined at compile time. When absent, the default value of an
item will be used.

The global structure of the configuration file is as follows:

[server]
   key_1 = value_1
   key_2 = value_2
   .
   .

[modem]
   key_1 = value_1
   key_2 = value_2
   .
   .

A `#' indicates the beginning of a comment. Comments continues 
until the end of the line. 
Currently the following keys are recognized in the section
\fImodem\fP:
.TP 10
.B server_dir
This specifies the directory where the \fImodemd\fP runs.
During startup, the server changes to this directory. All path names
described below can be defined relative to this directory.
.TP 10
.B access_log_file
Path name to a file in which access to the modem server is logged.
.TP 10
.B error_log_file
Path name to a file in which errors are logged.
.TP 10
.B account_log_file
Path name to a file in which accounting information is logged.
.TP 10
.B server_lock_file
Path name to lock file. In this file the process id (pid) of the
server is stored.
.TP 10
.B verify_user
Path name to program used to verify users permission to use a modem
device (see \fIverify_user\fP(1)).
.TP 10
.B verify_number
Path name to program used to verify users permission to dial a number
(see \fIverify_number\fP(1)).
.TP 10
.B server_umask
File mode creation mask for server process (see \fIumask\fP(1)).

.TP -10
In the section \fImodem\fP the following items can be configures:
.TP 10
.B modem_config_file
Path name to configuration file that contains device specific
configuration information (see \fImodems.conf\fP(5)).
.TP 10
.B modem_commands
Path name to configuration file that defines command sets of
different types of modems (see \fImodem_commands\fP(5)).

.SH SEE ALSO
.BR modemd "(1), 
.BR verify_user "(1),
.BR verify_number "(1),
.BR umask "(1),
.BR modms.conf "(5),
.BR modem_commands "(5)

.SH AUTHOR
Merijn de Jonge (mdejonge@wins.uva.nl)
.\"
.\" EOF modemd/modems.conf.man
.\"
