.\"
.\" $Id: modemd.man,v 1.12 1998/02/17 09:53:16 mdejonge Exp $
.\"
.\"   $Source: /home/mdejonge/CVS/projects/modem/modemd/modemd.man,v $
.\" $Revision: 1.12 $
.\"    Author: Merijn de Jonge
.\"     Email: mdejonge@wins.uva.nl
.\" 
.\"  
.\" 
.\" This file is part of the modem communication package.
.\" Copyright (C) 1996-1998  Merijn de Jonge
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\" 
.\"
.TH modemd 1 "Jan 19, 1997"

.SH NAME
modemd \- modem server which controls the available modems on a host.

.SH SYNOPSYS
.B modemd 
[-h] [-n] [-v]

.SH DESCRIPTION
\fImodemd\fP is the server that runs on each host on the network that shares
one or more modems. The \fImodemd\fP server controls all available modems on
one host. Each modem that is configured in modems.conf(5) is handled by
\fImodemd\fP.  When a request is received from modemcontrol(1) and both,
user and number verification (see below) succeeded, \fImodemd\fP allocates a
modem when available. \fImodemd\fP then forks and continues to listen for
new requests. The child will further serve its client, it will start dialing
a phone number and it will redirect all data read from the modem to the
client and vice versa. The server is configured using the optional
configuration file \fImodemd.conf\fP(5).

.SH OPTIONS
\fImodemd\fP accepts the following command line options:

.TP 8
.B -h 
This causes \fImodemd\fP to print out a verbose message describing its
options.
.TP 8
.B -n 
When using this option, \fImodemd\fP will enter the `no-daemon mode'. It
will not fork it self, it will log to standard error and SIGINT is caught
to terminate modemd.
.TP 8
.B -v
Prints the version number of \fImodemd\fP to standard output.

.SH PROTOCOL 
The \fImodemd\fP server listens for broadcast messages over the network.
When a broadcast message arrives, it will check whether a modem device is
available. When such a modem device exists, \fImodemd\fP will allocate a
unique \fIID\fP. \fImodemd\fP replies to the client by sending this
\fIID\fP. The \fIID\fP is remembered by \fImodemd\fP only for a short time.
After this period of time, the \fIID\fP is removed and the associated
client needs to send a new broadcast request. After the client receives its
\fIID\fP, it initiates a tcp connection with the \fImodemd\fP server that
replied to its request. At this point \fImodemd\fP forks. The child uses the
identd(1) server to get the host and user name of the client. It will verify
that the client's \fIID\fP is correct and executes verify_user(1) and
verify_number(1) to verify that this user is allowed to use the modem and
that he/she is allowed to dial the desired number.

.SH MODEM CONFIGURATION 
The modems that are used by \fImodemd\fP are configured in two files. The
first describes the terminal settings for each device. Only modems that are
configured in that file are controlled by \fImodemd\fP. See modems.conf(5)
for details on configuring the terminal settings for each device. The second
file configures the command set for each type of modem. In modems.conf(5)
each device is mapped to its modem class. In modem_commands(5) the command
set for each class is configured. See modem_commands(5) for more details.
The \fImodemd\fP server itself is configured in the optional configuration
file \fImodemd.conf\fP(5). When this file is missing default
values defined at compile time are used.
.SH LOGGING 

Log information is stored in several files. The exact path names to
these files depend on your particular installation (see installation
instructions) and can be configured in the
\fImodemd.conf\fP(5) configuration file.

The \fImodemd\fP server logs all established tcp connections to
\fIacess.log\fP.
After a connection is established the following log message is written to
\fIaccess.log\fP:
.TP 20
[<time stamp>][<modemd_host>] 
Connect from: "<user>@<client_host>"
.P
After a client is disconnected the following message is logged:
.TP 20
[<time stamp>][<modemd_host>] 
Disconnect from: "<user>@<client_host>"
.P
Here, <time_stamp> is the time at which the message is logged, <modemd_host>
is the host on which the \fImodemd\fP server is running, <user> is the name
of the user that is connected (according to identd(1)), and <client_host> is
the host name from which the connection is initiated.

Each established modem connection to a remote site is logged to
\fIaccount.log\fP. For each connection the following message is written:
.TP 20
<user>@<client_host>,<device>,<number>,
<modemd_host>,[<time_start>],[<time_end>]
.P 
Here, <device> is the modem device that is used, <time_start> is the time
stamp at which the modem connected and <time_end> is the time stamp at which
the modem disconnected.

Errors are all loged to \fIerror.log\fP. For each error the following
message is logged: 

[<time_Stamp>][<modemd_host>] <error message>

.SH AUTHENTICATION 
Before a user is allowed to dial a number, he/she should have
permission to make use of the modem software and to dial the desired
number. For reasons of flexibility the \fImodemd\fP server executes
two scripts to determine whether a client has permission. These
scripts return an exit value of zero (0) when access is granted, an
exit value of one (1) is returned when access has to be denied. The
script \fIverify_user\fP(1) is executed to determine whether <user> and
<client_host> are allowed to use the modem software.
\fIverify_number\fP(1)
is used to validate whether <user> from <client_host> is allowed to
dial <number>. In the default distribution, these scripts both return
zero, allowing anyone to connect and to dial any number. To install
this software on a particular system, one should possibly adapt these
scripts. <client_host> and <user> are determined according to
identd(1) when a tcp connection is established. The use of a unique
\fIID\fP after a broadcast request is received makes it hard to
connect to \fImodemd\fP without first having sent a broadcast
request.


.SH NOTES

The use of identd(1) for authentication may or may not be a problem for your
site. As is well known, the protocol used by identd (RFC 931) is as save as
the remote site. In other words, when untrusted hosts are able to connect to
your network, the identification mechanism used by \fImodemd\fP may not be
satisfactory for you. Please keep me informed about any improvements or
suggestions about this topic.

.SH FILES
The following files are used by modemd. Depending on settings defined at
compile time, the location of the files may differ.

.TP 32
/etc/modemd.conf
global configuration file of \fImodemd\fP server.
.TP 32
/etc/modems.conf
main configuration file for modems

.TP 32 
/usr/local/lib/modem_commands  
file describing command set for each class of modems

.TP 32 
/var/adm/modemd/access.log
Log file containing information about established tcp connection and
disconnections.

.TP 32
/var/adm/modemd/account.log
Log file containing information about modem connections (phone numbers,
durations etc)

.TP 32
/var/adm/modemd/error.log
Log file containing error messages from modemd

.SH SEE ALSO
.BR modemcontrol "(1),
.BR identd "(1),
.BR verify_number "(1),
.BR verify_user "(1),
.BR modemd.conf "(5),
.BR modems.conf "(5),
.BR modem_commands "(5)

.SH AUTHOR
Merijn de Jonge (mdejonge@wins.uva.nl)
.\"
.\" EOF modemd/modemd.man
.\"
