.\"
.\" $Id: modems.conf.man,v 1.8 1998/02/17 09:53:17 mdejonge Exp $
.\"
.\"   $Source: /home/mdejonge/CVS/projects/modem/modemd/modems.conf.man,v $
.\" $Revision: 1.8 $
.\"    Author: Merijn de Jonge
.\"     Email: mdejonge@wins.uva.nl
.\" 
.\"  
.\" 
.\" This file is part of the modem communication package.
.\" Copyright (C) 1996-1998  Merijn de Jonge
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\" 
.\"
.TH modems.conf 5 "Jan 16, 1997"
.SH NAME
/etc/modems.conf \- configuration file for modems

.SH DESCRIPTION 

The \fImodems.conf\fP file is used by the modem server (see
modemd(1)). This configuration file should contain a section
for each available modem device on a host. Each section
describes the characteristics of the modem device
The \fImodemd\fP server will use only modems included
in this file. The configuration file constists of sections, one for
each modem, and each sections consists of optional key/value pairs.
The key/value pairs describe the terminal settings (like speed,
number of stop bits etc.) and the type of modem. This type (e.g.
hayes), which can be any string, is used in modem_commands(5) to
select the correct command set for the modem device. All key/value
pairs are optional. When missing, a default value is used which is
defined at compile time. Unrecognized keys are silently ignored.

The global structure of the configuration file is as follows:

[modem_1]
   key_1 = value_1
   key_2 = value_2
   .
   .

[modem_2]
   key_1 = value_1
   key_2 = value_2
   .
   .

A `#' indicates the beginning of a comment. Comments continues 
until the end of the line. The modem device name is determined by
prefixing the section heading by `/dev/'. For example, above two
devices are configured. The first device is `/dev/modem_1', the
second is called `/dev/modem_2'. This naming scheme may have its
limitations and may change in the future.
Currently the following keys are recognized :
.TP 10
.B databits
Number of bits per byte for both transmission and reception (valid
values are 5, 6, 7 and 8). Default value is 8.
.TP 10
.B parity
Configures parity checking. Valid values are N (no parity checking),
O (odd parity checking) and E (even parity checking). Default is N.
.TP 10
.B speed
Configures speed of device. Valid values are: 0, 50, 75, 110, 300,
600, 1200, 2400, 4800, 9600, 14400, 19200, 38400, 57600, 115200.
Default is 38400.

.TP 10
.B stopbits
Configures number of stopbits. Valid values are: 1 (for one stop bit)
and 2 (for two stop bits). Default is 1.

.TP 10
.B type
Maps modem device to its class (e.g. hayes). Type is used to
determine the device its command set (see modem_commands(5)).

.SH NOTES 
The naming scheme that is being used prevents from using more
symbolic names for the section headers due to the cryptic device
names. Moreover, it assumes the devices to be in the /dev directory,
which may turn out to be a strong restriction in the future. Because
of these restrictions, the naming scheme may change in the future.

.SH SEE ALSO
.BR modemd "(1), 
.BR modem_commands "(5)

.SH AUTHOR
Merijn de Jonge (mdejonge@wins.uva.nl)
.\"
.\" EOF modemd/modems.conf.man
.\"
