/*
 * $Id: request.c,v 1.9 1998/02/17 09:53:17 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/modemd/request.c,v $
 * $Revision: 1.9 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include "request.h"

/* Declaration  of request list */
#define MAX_REQUESTS 10
static request requestList[MAX_REQUESTS];
static int request_ind = 0;

/*
 * Make new request and store it in requestList
 * return the new request or NULL when requestList
 * is full
 */
request* requestNew()
{
   static long nr = 1;

   if( request_ind == MAX_REQUESTS )
      return NULL;
   requestList[request_ind].time_stamp = time(NULL);
   requestList[request_ind].nr   = nr;
   
   nr++;
   request_ind++;

   return &requestList[request_ind - 1];
}


/* 
 * Compare two request Id's a and b
 * return 1 when a == b
 *        0 otherwise
 */
int requestIdCmp( request a, request b )
{
   return a.time_stamp == b.time_stamp &&
          a.nr == b.nr;
}

          

/* Reset the list */
void requestListInit()
{
   request_ind = 0;
}

/* 
 * Reset the list.
 * For savety reasons, all requests are removed from the list 
 * When no clients are connecting.
 * A client thus, should connect to the server as soon as possible
 */
void requestListReset()
{
   requestListInit();
}

/* Remove request from list */
void requestListRemove( request id )
{
   int i;
   i = requestListLookup( id );
   if( i == -1 )
      return;
   request_ind--;
   for( ; i < request_ind; i++ )
      requestList[i] = requestList[i + 1];
}

/* Check for request with request id in list */
int requestListLookup( request id )
{
   int i;
   for( i = 0; i < request_ind; i++ )
      if( requestIdCmp( requestList[i], id ) )
         return i;
   return -1;
}


/*
 * EOF modemd/request.c
 */
