/*
 * $Id: request.h,v 1.7 1998/02/17 09:53:18 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/modemd/request.h,v $
 * $Revision: 1.7 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef _request_h
#define _request_h

/*
 * Description:
 *
 * Whenever a client sends a broadcast message to the server, the server
 * returns a request_ID to that client. The server allocates a request, with
 * the hostname of the client and the user name of the client, which the
 * client sends as broadcast message. The client knows that the server is
 * willing to server when it receives the request_ID from the server. The
 * client makes a TCP/IP connection to the server, and for authentication
 * sends the request_ID back to the server. The server checks it's list of
 * requests to see if it contains a request with the same id. If this is the
 * case, the server accepts the connection.
 *
 */
#include <time.h>


#define MDM_BROADCAST "mdm_broadcast"

/* Definition of datatype request */
typedef struct
{
   time_t time_stamp;
   long nr;
} request;

/* compare two request ID's */
int requestIdCmp( request a, request b );

/* Allocate new request */
request* requestNew();

/* Initialize list of requests */
void requestListInit();

/* Reset the list */
void requestListReset();

/* Remove request from the list */
void requestListRemove( request id );

/* Look for specific request in list */
int requestListLookup( request id );

#endif
/*
 * EOF modemd/request.h
 */
