/*
 * $Id: rfc931.c,v 1.10 1998/02/17 09:53:19 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/modemd/rfc931.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <setjmp.h>
#include <signal.h>

#include <libtcpip/libtcpip.h>
#include <liberror/liberror.h>
#include <libport/libport.h>
#include "modem_defs.h"
#include "modemd.h"

#define ANY_PORT 0     /* Any old port will do */
/* Default  port for ident service  */
#define IDENT_DEFAULT_PORT    113
/* Name of ident (RFC931) service */
#define IDENT_SERVICE         "ident"
/* After this time in seconds considder indentd daemon down. */
#define IDENT_TIMEOUT         10

static jmp_buf timebuf;

static void timeout( int sig )
{
   longjmp( timebuf, sig );
}

/*
 * lookup the owner of a tcp connection
 */
char* rfc931( sockStruct* remote, sockStruct* local )
{
   sockStruct ident;
   char       buf[512];
   static     char user[512];
   unsigned   rmt_port;
   unsigned   our_port;
   static     char* uname;
   char*      ptr;
   int        result;
   struct     sigaction siga;
   struct     sigaction act;

   uname = FROM_UNKNOWN;
   
   sockSetProtocol( &ident, TCP );
   if( sockSetPortToService( &ident, IDENT_SERVICE ) == -1 )
      sockSetPort( &ident, IDENT_DEFAULT_PORT );

   if( sockClient( &ident, sockConnectedTo( remote ) ) == -1 )
   {
      FAIL( "sockClient" );
      exit( 1 );
   }
   if( sockConnect( &ident ) == -1 )
   {
      FAIL( "sockConnect" );
      exit( 1 );
   }
   
   TEMP_FAILURE_RETRY( result, sigaction( SIGALRM, NULL, &siga ) );
   if( setjmp( timebuf ) == 0 )
   {
      sigemptyset( &act.sa_mask );
      act.sa_handler = timeout;
#ifdef SA_RESTART
      act.sa_flags   = SA_RESTART;
#endif
      
      sigaction( SIGALRM, &act, NULL );
      alarm( IDENT_TIMEOUT );
   
      
      sprintf( buf, "%u,%u\r\n",
         ntohs( remote->port ),
         ntohs( local->port ) );

      TEMP_FAILURE_RETRY( result, sockSend( &ident, buf, strlen( buf ) ) );
      if( result < 0 )
      {
         FAIL( "sockSend" );
         exit( 1 );
      }
      
      TEMP_FAILURE_RETRY( result, read( ident.fd, buf, sizeof( buf ) ) );
      if( result < 0 )
      {
         FAIL( "sockRecv" );
         exit( 1 );
      }
      if( sscanf(buf, "%u , %u : USERID :%*[^:]:%255s",
         &rmt_port, &our_port, user) == 3 )
      {
         if( ntohs( remote->port ) == rmt_port &&
             ntohs( local->port ) == our_port )
         {
            ptr = strchr( user, '\r' );
            if( ptr != NULL )
               *ptr = '0';
            uname = user;
         }
      }
   }
   close( ident.fd );
   alarm( 0 );
   TEMP_FAILURE_RETRY( result, sigaction( SIGALRM, &siga, NULL ) );
   return uname;
}
/*
 * EOF modemd/rfc931.c
 */
