/*
 * $Id: server.c,v 1.9 1998/02/17 09:53:19 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/modemd/server.c,v $
 * $Revision: 1.9 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libtcpip/libtcpip.h>
#include <liberror/liberror.h>
#include <libport/libport.h>

#include <modem_defs.h>
#include "modemd.h"
#include "request.h"
#include "log.h"
#include "syscmd.h"
#include "auth.h"

/*
 * Server process 
 */
void server()
{
   sockStruct  sock_tcp;
   sockStruct  sock_udp;
   sockStruct  client_tcp;
   const char* name;
   const char* host;
      
   fd_set active_fd_set, read_fd_set;
   int i;
   int result;
   struct timeval timeout;
   char hostName[40];
   pid_t pid;
      
   gethostname( hostName, sizeof(hostName ) );
   /* Initialize request list */
   requestListInit();

   /* 
    * Setup the network.
    * Need socket for UDP and for TCP
    */
   sockSetProtocol( &sock_tcp, TCP );
   sockSetProtocol( &sock_udp, UDP );

      
   /* Set port to use */
   if( sockSetPortToService( &sock_tcp, TCP_SERVICE ) == -1 )
   {
      fprintf( ERR_LOG, "%s[%s] Unknown service %s, using default port: %d\n",
          timeStamp(), hostName, TCP_SERVICE, TCP_DEFAULT_PORT  );
      sockSetPort( &sock_tcp, TCP_DEFAULT_PORT );
   }
   if( sockSetPortToService( &sock_udp, UDP_SERVICE ) == -1 )
   {
      fprintf( ERR_LOG, "%s[%s] Unknown service %s, using default port: %d\n",
          timeStamp(), hostName, UDP_SERVICE, UDP_DEFAULT_PORT  );
      sockSetPort( &sock_udp, UDP_DEFAULT_PORT );
   }


   /* Initialize sockets */
   if( 
      sockServer( &sock_tcp ) ||
      sockListen( &sock_tcp ) ||
      sockServer( &sock_udp )
      == -1 )
   {
      FAIL( "setup error" );
      exit( 1 );
   }

   /* 
    * allow reuse of local addresses
    */
   if( sockSetOption( &sock_tcp, SO_REUSEADDR, 1 ) ||
       sockSetOption( &sock_udp, SO_REUSEADDR, 1 ) == -1 )
   {
      FAIL( "sockSetOption" );
      exit( 1 );
   }
   
   /* Wait for data from sock_tcp and sock_udp */
   FD_ZERO( &active_fd_set );
   FD_SET( sock_tcp.fd, &active_fd_set );
   FD_SET( sock_udp.fd, &active_fd_set );
   
   while( 1 )
   {
      read_fd_set = active_fd_set;
      timeout.tv_sec = 5;
      timeout.tv_usec = 0;
      /* Wait for data from sock_tcp and sock_udp */
      TEMP_FAILURE_RETRY( result, 
         select( FD_SETSIZE, &read_fd_set, NULL, NULL, &timeout ) );
      if( result < 0 )
      {
         FAIL( "select" );
         exit( 1 );
      }
      if( result == 0 )
      {
         /* Timed out. 
          * Remove all requests from list. 
          */
         requestListReset();
         continue;
      }           
      for( i = 0; i < FD_SETSIZE; ++i )
      if( FD_ISSET( i, &read_fd_set ) )
      {
         if( i == sock_tcp.fd )
         {
            /* Connection from client */
            if( sockAccept( &sock_tcp, &client_tcp ) == -1 )
            {
               FAIL( "sockAccept" );
               exit( 1 );
            }
            /* Add fd to set of fd's */
            FD_SET( client_tcp.fd, &active_fd_set );
         }
         else
         if( i == sock_udp.fd )
         {
            /* Broadcast message from a client. Create new request */
            new_request( &sock_udp );
         }
         else
         {
            pid = fork();
            switch( pid )
            {
               case 0:
                  /* Get name of remote user */
                  name = rfc931( &client_tcp, &sock_tcp );
                  /* Get host of remote user */
                  host = sockConnectedTo( &client_tcp );
                  check_client( i, host, name );
                  /* Everything is alright -> serve the client */
                  handle_client( i, host, name );
                  exit( 0 );
               case -1:
                  FAIL( "fork" );
                  exit( 1 );
               default:
                  /* Close client's fd */
                  if( close( i ) == -1 )
                  {
                     FAIL( "close" );
                     exit( 1 );
                  }

                  FD_CLR( i, &active_fd_set );
                  break;
            }
         }
      }
   }
}
/*
 * EOF modemd/server.c
 */
