/*
 * $Id: syscmd.c,v 1.11 1998/02/17 09:53:21 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/modemd/syscmd.c,v $
 * $Revision: 1.11 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
/*
 * Partly based on system.c from GNU C Library,
 * see copyright below.
 */

/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>

#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#include <signal.h>
#include <sys/types.h>

#include <libport/libport.h>
#include <liberror/liberror.h>
#include <libport/libport.h>
#include "syscmd.h"

#define MAX_ARGS  20

static char* args[MAX_ARGS];

/*
 * Build fill array args with pointers to 
 * arguments in ap
 *
 * End of elements is indicated by NULL pointer in args.
 *
 */
void build_cmd( const char* cmd, va_list ap )
{
   int nr_args = 1;
   char* ptr;
   args[0] = (char*)cmd;
   
   while( 1 )
   {
      ptr = va_arg( ap, char* );
      args[nr_args] = ptr;
      if( ptr == NULL )
         return;
      nr_args++;
   }
}

/*
 * Execute cmd with args
 * Similar to system(2) function call except
 * no shell is invoked and variable number of
 * arguments can be used.
 *
 */
int sys_cmd( const char* cmd, ... )
{
   va_list ap;
   int status, save;
   int retval;
   pid_t pid;
   struct sigaction sa, intr, quit, chld;
   sigset_t block, omask;

   va_start( ap, cmd );
   build_cmd( cmd, ap );
   va_end( ap );

   sa.sa_handler = SIG_IGN;
   sa.sa_flags = 0;
   sigemptyset( &sa.sa_mask );

   if( sigaction( SIGINT, &sa, &intr ) < 0)
      return -1;
   if( sigaction( SIGQUIT, &sa, &quit ) < 0)
   {
      save = errno;
      sigaction( SIGINT, &intr, NULL );
      errno = save;
      return -1;   
   }
   
   sa.sa_handler = SIG_DFL;
   if( sigaction( SIGCHLD, &sa, &chld ) < 0 )
   {
      save = errno;
      sigaction( SIGQUIT, &quit, NULL );
      sigaction( SIGINT, &intr, NULL );
      errno = save;
      return -1;
   }

   sigemptyset( &block );
   sigaddset( &block, SIGCHLD );
   save = errno;
   if( sigprocmask( SIG_BLOCK, &block, &omask ) < 0 )
   {
      if( errno == ENOSYS )
         errno = save;
      else
      {
         save = errno;
         sigaction( SIGINT, &intr, NULL );
         sigaction( SIGQUIT, &quit, NULL );
         sigaction( SIGCHLD, &chld, NULL );
         errno = save;
         return -1;   
      }
   }
   pid = fork();
   switch( pid )
   {
      case 0:
         /* Child side.  */
         /* Restore the signals.  */
         sigaction( SIGINT, &intr, NULL);
         sigaction( SIGQUIT, &quit, NULL);
         sigaction( SIGCHLD, &chld, NULL );
         sigprocmask( SIG_SETMASK, &omask, NULL); 

         /* Exec the shell.  */
         execv( cmd, args );
         FAIL1( "execv", cmd );
         
         _exit(127);
      case -1:
       /* The fork failed.  */
         status = -1;
         break;
      default:
         /* Parent side.  */
         TEMP_FAILURE_RETRY( retval,
                             waitpid( pid, &status, 0 )
                           );
         if( retval != pid )
            status = -1;
   }
   
   save = errno;
   if( (sigaction( SIGINT, &intr, NULL ) |
        sigaction( SIGQUIT, &quit, NULL) |
        sigaction( SIGCHLD, &chld, NULL ) |
        sigprocmask( SIG_SETMASK, &omask, NULL ) ) != 0 )
   {
      if( errno == ENOSYS )
         errno = save;
      else
         return -1;
   }
            
   return status;
}


/*
 * EOF modemd/syscmd.c
 */
