.\"
.\" $Id: modemlogin.man,v 1.5 1998/02/17 09:53:25 mdejonge Exp $
.\"
.\"   $Source: /home/mdejonge/CVS/projects/modem/modemlogin/modemlogin.man,v $
.\" $Revision: 1.5 $
.\"    Author: Merijn de Jonge
.\"     Email: mdejonge@wins.uva.nl
.\" 
.\"  
.\" 
.\" This file is part of the modem communication package.
.\" Copyright (C) 1996-1998  Merijn de Jonge
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\" 
.\"
.TH modemlogin 1 "January 13 1997"


.SH NAME
\fBmodemlogin\fP \- Program to login using a modem device.

.SH SYNOPSIS
.B modemlogin
[-\fItoolkitoption\fP ...] [-\fIoption\fP ...]

.SH DESCRIPTION
\fImodemlogin\fP
prompts the user to enter user name and password and tries to login
by reading data from the modem device (standard input by default)
until a login prompt is recognized. When a login prompt is detected,
\fImodemlogin\fP writes the user name to the modem device (standard
output by default) and waits until a password prompt is detected.
After writing the password to the modem device (standard output by
default), it waits for either a failure indication or something else
indicating a login success. When the login is incorrect,
\fImodemlogin\fP informs the user and the login process starts over
again until either the user cancels or the login process has
succeeded.

\fIlogin\fP can use the information stored in your personal phone book
(\fI~/.phonebook\fP) to fill the user name and password entries of the login
dialog. For information about your phone book see
phonebook(5).

.SH OPTIONS
\fImodemlogin\fP accepts all of the standard X Toolkit command line options as
well as the following.
.TP 8
.BI -e  " name"
With this option \fImodemlogin\fP gets the login and/or password from you
phone book entry \fIname\fP (see phonebook(5)).
.TP 8
.B -h
This causes \fImodemlogin\fP to print out a verbose message describing its
options.
.TP 8
.B -l
This option indicates that \fImodemlogin\fP should not prompt you to enter 
your login and password when this information can be determined according 
to the entry in your phone book as specified with the -e option. 
Instead, \fImodemlogin\fP will start login in immediately.
.TP 8
.BI -m " dev"
Use modem device \fIdev\fP to send login and password to. By default standard
input/standard output is used.
.TP 8
.B -v
Prints the version number of \fImodemlogin\fP to standard output.

.SH FILES
.ta 15n 20n
.nf
~/.phonebook		Personal phone book

.SH SEE ALSO

.BR modemd "(1),
.BR modemcontrol "(1), 
.BR ppp "(1), 
.BR phonebook "(5)

.SH AUTHOR
Merijn de Jonge (mdejonge@wins.uva.nl)

.\"
.\" EOF modemlogin/modemlogin.man
.\"
