/*
 * $Id: main.c,v 1.5 1998/02/17 09:53:27 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/modemtalk/main.c,v $
 * $Revision: 1.5 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#ifdef HAS_GETOPT_H
#include <getopt.h>
#endif
extern char* optarg;

#include <liberror/liberror.h>
#include <libtty/libtty.h>

#define USAGE_MSG \
   "modemtalk (" ## VERSION ## ")\n"\
   "usage:\n" \
   "      modemtalk [-h] [-m dev]\n" \
   "\n" \
   "where options include:\n" \
   "     -h           print out this message\n" \
   "     -m dev       use modem device dev\n" \
   "     -v           displays version information\n"\
   "\n"
#define VERSION_MSG \
   "modemtalk version " ## VERSION ## "\n"
   
static char* opt_string = "hm:v";

static void usage()
{
   fprintf( stdout, USAGE_MSG );
}

static void version()
{
   fprintf( stdout, VERSION_MSG );
}

void main( int argc, char* argv[] )
{
   int fdesc;
   int bytes;
   int i;
   int dest;
   int nfsd;
   int c;
   fd_set io;
   char buf[512];
   char* device;
   
   /* get device name from environment */
   device = getenv( "MODEM" );
   
   /* parse command line arguments */
   while( 1 )
   {
      c = getopt( argc, argv, opt_string );
      if( c == -1 )
         break;
      switch( c )
      {
         case 'h' :
            usage();
            exit( 0 );
         case 'm' :
            device = strdup( optarg );
            break;
         case 'v' :
            version();
            exit( 0 );
         default:
            exit( 1 );
            break;
      }
   }

   /* open terminal (modem) device */
   fdesc = open( device, O_RDWR );
   if( fdesc == -1 )
   {
      FAIL( "open" );
      exit( 1 );
   }
   ttySetRaw( STDIN_FILENO );


   /*
    * enter loop. Data reseived from stdin is copied to fdesc.
    * data read from fdesc is written to stdout
    */
   while( 1 )
   {
      FD_ZERO( &io );
      FD_SET( fdesc, &io );
      FD_SET( STDIN_FILENO, &io );

      nfsd = select( FD_SETSIZE, &io, NULL, NULL, NULL );
      if( nfsd < 0 )
      {
         FAIL( "select" );
         exit( 1 );      
      }

      if( nfsd > 0 )
         for( i = 0; i < FD_SETSIZE; i++ )
            if( FD_ISSET( i, &io ) )
            {
               if( i == STDIN_FILENO )
                  dest = fdesc;
               else
                  dest = STDOUT_FILENO; /* stdout */

               /* read from device */
               bytes = read( i, buf, sizeof( buf ) );
               if( bytes < 0 )
               {
                  FAIL( "read" );
                  exit( 1 );
               }
               /* eof */
               if( bytes == 0 )
                  exit( 0 );

               bytes = write( dest, buf, bytes );
               if( bytes < 0 )
               {
                  FAIL( "write" );
                  exit( 1 );
               }
               if( bytes == 0 )
                  exit( 0 ); /* eof */
            }
   }
}
/*
 * EOF modemtalk/modemtalk.c
 */
