.\"
.\" $Id: ppp.man,v 1.11 1998/02/17 09:53:33 mdejonge Exp $
.\"
.\"   $Source: /home/mdejonge/CVS/projects/modem/scripts/ppp.man,v $
.\" $Revision: 1.11 $
.\"    Author: Merijn de Jonge
.\"     Email: mdejonge@wins.uva.nl
.\" 
.\"  
.\" 
.\" This file is part of the modem communication package.
.\" Copyright (C) 1996-1998  Merijn de Jonge
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\" 
.\"
.TH ppp 1 "Jan 15, 1997"
.SH NAME
ppp \- script for managing a ppp link using a modem somewhere on your network

.SH SYNOPSIS
.B ppp 
[-\fIoption\fP ...] [\fIphone book entry\fP]
.SH DESCRIPTION 

The \fIppp\fP script is a shell script that is used to initiate and handle a
\fBppp\fP (Point to Point Protocol) connection to a remote site. The script
executes modemcontrol(1) which communicates with an available modem
somewhere on your network. After establishing a connection \fIppp\fP
executes modemlogin(1) to log you into the network. Finally when you are logged
in, the program pppd(1) is started, which initiates the \fBppp\fP link. When
you are connected \fImodemcontrol\fP displays a status dialog which gives
information about the connection (speed, elapsed time, bytes read and sent).
For a detailed description of \fImodemcontrol\fP see its manual page.

.SH OPTIONS 
\fIppp\fP accepts the following options:

.TP 8
.B -h 
This causes \fIppp\fP to print out a verbose message describing its options.
.TP 8
.B -l 
This option instructs \fImodemlogin\fP to use the user name and password for the
login process from your phone book according to the entry as given as last
argument to \fIppp\fP. When one or both of these entries are missing in your
phone book or the entry was invalid, \fImodemlogin\fP will still prompt you to
enter your login or password or both.
.TP 8
.B -q 
When you specified a phone book entry (the last argument to \fIppp\fP) and a
phone number can be determined according to this entry (see
phonebook(5)), the -q option instructs \fImodemcontrol\fP not to prompt for a
phone number.
.TP 8
.B -r 
This option instructs \fImodemcontrol\fP to re-dial automatically when the
line is busy.
.TP 8
.B -v
Prints the version number of \fIppp\fP to standard output.

.LP
Any other option given on the command line is passed to both
\fImodemcontrol\fP and \fImodemlogin\fP. By doing so the standard X Toolkit
command line options become available to these tools (but see the note's
section below).

.SH ENVIRONMENT
\fIppp\fP uses the environment variable \fIMODEM\fP 
that points to the pseudo terminal that has to be used to
communinicate with the remote modem. The variable is set by
modemcontrol(1).


.SH NOTES 
\fIppp\fP assumes the availability of the \fIppp\fP package from Drew
Perkins and others on your system. This package is available from anonymous
ftp at cs.anu.edu.au/pub/software/ppp. Due to the differences in the login
process among sites, it could be possible that the \fIppp\fP script needs to
be adapted for such a site. Please consult your system administrator when
connecting to your site needs special actions.

By passing unrecognized arguments to \fImodemcontrol\fP and \fImodemlogin\fP,
these tools become responsible for checking the validity of their arguments.
Incorrect command line options are therefor recognized not until these tools
are executed. For this reason this way of handling command line arguments
may change in the future.

.SH SEE ALSO
.BR modemcontrol "(1), 
.BR modemlogin "(1), 
.BR phonebook "(5), 
.BR pppd "(8)

.SH AUTHOR
Merijn de Jonge (mdejonge@wins.uva.nl)
 
.\"
.\" EOF scripts/ppp.man
.\"
