.\"
.\" $Id: xcomm.man,v 1.11 1998/02/17 09:53:36 mdejonge Exp $
.\"
.\"   $Source: /home/mdejonge/CVS/projects/modem/scripts/xcomm.man,v $
.\" $Revision: 1.11 $
.\"    Author: Merijn de Jonge
.\"     Email: mdejonge@wins.uva.nl
.\" 
.\"  
.\" 
.\" This file is part of the modem communication package.
.\" Copyright (C) 1996-1998  Merijn de Jonge
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\" 
.\"
.TH xcomm 1 "Jan 16, 1997"
.SH NAME
xcomm \- script for serial communication using a modem somewhere on your
network.

.SH SYNOPSIS
.B xcomm 
[-\fIoption\fP ...] [\fIphone book entry\fP]

.SH DESCRIPTION 

The \fIxcomm\fP script is a shell script that is used to initiate and handle
a serial connection using one of the available modems on your network. The
script executes modemcontrol(1) which communicates with an available modem
on your network. After establishing a connection \fIxcomm\fP executes a
program which handles your communication with the remote site. Depending on
the installation this program can be a third party communication program
(like the well known minicom program, available via ftp at:
sunsite.unc.edu:/pub/Linux/apps/comm) or the very basic communication
program modemtalk(1) which is included in the modem package. When you are
connected \fImodemcontrol\fP displays a status dialog which gives
information about the connection (speed, elapsed time, bytes read and sent).
For a detailed description of \fImodemcontrol\fP see its manual page.

.SH OPTIONS 
\fIxcomm\fP accepts the following options:

.TP 8
.B -h 
This causes \fIxcomm\fP to print out a verbose message describing its options.
.TP 8
.B -q 
When you specified a phone book entry (the last argument to \fIxcomm\fP) and
a phone number can be determined according to this entry (see phonebook(5)),
the -q option instructs \fImodemcontrol\fP not to prompt for a phone number.
.TP 8
.B -r 
This option instructs \fImodemcontrol\fP to re-dial automatically when the
line is busy.
.TP 8
.B -v
Prints the version number of \fIxcomm\fP to standard output.

.LP
Any other option given on the command line is passed to modemcontrol. By
doing so the standard X Toolkit command line options become available to
\fImodemcontrol\fP (but see the note's section below).

.SH ENVIRONMENT
\fIxcomm\fP uses the environment variable \fIMODEM\fP 
that points to the pseudo terminal that has to be used to
communinicate with the remote modem. The variable is set by
modemcontrol(1).

.SH NOTES 
The program which is executed by \fIxcomm\fP depends on the installation.
The communication program that is executed can be any communication program
as long as it is able to use an already initiated line.

By passing unrecognized arguments to \fImodemcontrol\fP, this tool becomes
responsible for checking the validity of its arguments. Incorrect command
line options are therefor recognized not until \fImodemcontrol\fP is executed. For
this reason this way of handling command line arguments may change in the
future.

.SH SEE ALSO
.BR modemcontrol "(1), 
.BR modemtalk "(1), 
.BR phonebook "(5)

.SH AUTHOR
Merijn de Jonge (mdejonge@wins.uva.nl)
 
.\"
.\" EOF scripts/xcomm.man
.\"
