/*
 * $Id: ts.c,v 1.12 1998/02/17 09:53:39 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/tests/ts.c,v $
 * $Revision: 1.12 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */

/* 
 * finds all modem servers on the net as specified 
 * on the commandline.
 *
 * usage:
 *   ts [hostspec]
 *      hostspec   hostname or broadcast address
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include <pwd.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>

#include <libtcpip/libtcpip.h>
#include <liberror/liberror.h>
#include <modem_defs.h>
#include "../modemd/request.h" /* for request */

int nr_servers = 0;

/*     
 * Wait for broadcast reply from modem server
 */
static int modemClientBroadcast( int fd )
{
   fd_set rfds;
   struct timeval timeout;
   int retval;
   
   while( 1 )
   {
      timeout.tv_sec = SERVER_TIMEOUT;
      timeout.tv_usec = 0;
   
      FD_ZERO( &rfds );
      FD_SET( fd, &rfds );
      retval = select( FD_SETSIZE, &rfds, NULL, NULL, &timeout );
       
      if( retval < 0 )
      {
         if( errno == EINTR )
            continue;
         FAIL( "select" );
         exit( 1 );
      }
      return retval;
   }   
}

int modemClientConnect( const char* host )
{
   uid_t          me;
   struct passwd* pwd;
   sockStruct     sock_udp;
   sockStruct     server;  
   const char*    serverName;
   request        id;
   
   me  = getuid();
   pwd = getpwuid( me );

   /* Initialise sockets */
   sockSetProtocol( &sock_udp, UDP );
 
   if( sockSetPortToService( &sock_udp, UDP_SERVICE ) == -1 )
   {
      error( "Unknown service: %s, using default port: %d",
         UDP_SERVICE, UDP_DEFAULT_PORT );
      sockSetPort( &sock_udp, UDP_DEFAULT_PORT );
   }

   if( sockClient( &sock_udp, host ) == -1 )
   {
      FAIL( "udp" );
      exit( 1 );
   }
    
   if( sockSetOption( &sock_udp, SO_BROADCAST, 1 ) < 0 )
   {
      FAIL( "sockSetOption" );
      exit( 1 );
   }
    
   /* Send broadcast message to the network. Send username as message */
   if( sockSend( &sock_udp, pwd->pw_name, strlen( pwd->pw_name ) + 1) == -1 )
   {
      FAIL( "sockSend" );
      exit( 1 );
   }
    
   while( 1 )
   {
      /* Wait for a reply from server */
      if( modemClientBroadcast( sock_udp.fd ) == 0 )
      {
         error( "No servers found on the net" );
         exit( 1 );
      }
       
      /* Read request from server */
      if( sockRecv( &sock_udp, &server, &id, sizeof( id ) ) == -1 )
      {
         FAIL( "recvfrom" );
         exit( 1 );
      }
       
      /* Get name of server who replied */
      serverName = sockConnectedTo( &server );
      nr_servers++;
      fprintf( stderr, "Found host: %s\n", serverName );
   }
}   

void endtest()
{
   fprintf( stderr, "Test ended\n" );
   fprintf( stderr, "found %d server(s) on the net\n", nr_servers );
}

void main( int argc, char* argv[] )
{
   if( argc != 2 )
   {
      fprintf( stderr, "usage: %s hostname (or address)\n\n", argv[0] );
      exit( 1 );
   }
   atexit( endtest );
   signal( SIGALRM, exit );
   alarm( 5 );
   fprintf( stderr, "Test started\n" );
   modemClientConnect( argv[1] );
}
/*
 * EOF tests/ts.c
 */
