// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccscript.
// 
// The exception is that, if you link the ccscript library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccscript library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name ccscript.  If you copy code from other releases into a copy of
// ccscript, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own for ccscript, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.

#include <cc++/config.h>
#include <cc++/misc.h>
#include <cc++/slog.h>
#include <cc++/file.h>
#include <cc++/export.h>
#include <cstdlib>
#include "bayonnescript.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

Script::Locks ScriptInterp::locks;

Script::Locks::Locks() :
ThreadLock(), MemPager(1024)
{
	unsigned id;

	for(id = 0; id < KEYWORD_INDEX_SIZE; ++id)
		hash[id] = NULL;

	count = 0;
}

unsigned Script::Locks::getIndex(const char *id)
{
        unsigned int key = 0;

        while(*id)
                key ^= (key << 1) ^ (*(id++) & 0x1f);

        return key % KEYWORD_INDEX_SIZE;
}

void Script::Locks::release(ScriptInterp *interp)
{
	unsigned id;
	lck *node;
	unsigned found = 0;

	if(!count || !interp->lckcount)
		return;

	readLock();

	for(id = 0; id < KEYWORD_INDEX_SIZE; ++id)
	{
		node = hash[id];
		while(node)
		{
			if(node->owner == interp)
			{
				node->owner = NULL;
				++found;
			}
			node = node->next;
		}
	}

	ThreadLock::unlock();

	if(!found)
		return;

	writeLock();
	count -= found;
	interp->lckcount = 0;
	if(!count)
	{
		purge();
		for(id = 0; id < KEYWORD_INDEX_SIZE; ++id)
			hash[id] = NULL;
	}
	ThreadLock::unlock();
}	

bool Script::Locks::lock(ScriptInterp *interp, const char *id)
{
	unsigned key = getIndex(id);
	lck *node;
	char buf[10];
	size_t len = strlen(id) + 1;
	
	writeLock();
	node = hash[key];

	while(node)
	{
		if(!stricmp(id, node->id))
			break;

		node = node->next;
	}

	if(!node)
	{
		node = (lck *)alloc(sizeof(lck) + len - 1);
		node->owner = NULL;
		setString(node->id, len, id);
		node->next = hash[key];
		hash[key] = node->next;
	}

	if(node->owner == interp)
	{
		ThreadLock::unlock();
		return true;
	}

	if(node->owner)
	{
		snprintf(buf, sizeof(buf), "%d", ++node->count);
		interp->setSymbol("script.locks", 10);
		interp->setSymbol("script.locks", buf);
		ThreadLock::unlock();
		return false;
	}

	++count;
	++interp->lckcount;
	node->count = 0;
	node->owner = interp;
	ThreadLock::unlock();
	return true;
}

bool Script::Locks::unlock(ScriptInterp *interp, const char *id)
{
	lck *node;
	unsigned key = getIndex(id);

	writeLock();
	node = hash[key];

	while(node)
	{
		if(!stricmp(node->id, id))
			break;

		node = node->next;
	}

	if(!node)
	{
		ThreadLock::unlock();
		return false;
	}

	if(node->owner != interp)
	{
		ThreadLock::unlock();
		return false;
	}

	node->owner = NULL;
	--interp->lckcount;
	if(--count)
	{
		ThreadLock::unlock();
		return true;
	}

	for(key = 0; key < KEYWORD_INDEX_SIZE; ++key)
		hash[key] = NULL;

	purge();
	ThreadLock::unlock();
	return true;
}

#ifdef	CCXX_NAMESPACES
}
#endif












