// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccscript.
// 
// The exception is that, if you link the ccscript library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccscript library code into it.
//
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
//
// This exception applies only to the code released under the
// name ccscript.  If you copy code from other releases into a copy of
// ccscript, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own for ccscript, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.

#include <cc++/config.h>
#include <cc++/misc.h>
#include <cc++/slog.h>
#include <cc++/file.h>
#include <cc++/thread.h>
#include <cc++/process.h>
#include <cc++/export.h>
#include "bayonnescript.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

Script::Package *Script::Package::first = NULL;
ScriptModule *ScriptModule::first = NULL;
Script::PreParse *ScriptModule::preparse = NULL;
Script::Property *Script::Property::first = NULL;
Script::InitScript *ScriptModule::inits = NULL;

Script::Property::Property(const char *name)
{
	id = name;
	next = first;
	first = this;
}

Script::Property *Script::Property::find(const char *name)
{
	Property *prop = first;

	while(prop)
	{
		if(!stricmp(prop->id, name))
			break;
		prop = prop->next;
	}
	return prop;
}

ScriptModule::ScriptModule(const char *name, Script::Method method)
{
	next = first;
	first = this;

	if(method == (Method)NULL)
		method = &ScriptInterp::scrLoadable;

	handler = method;
	cmd = name;
}

void ScriptModule::addInit(Script::Init handler)
{
	Script::InitScript *p = new Script::InitScript;
	p->handler = handler;
	p->next = inits;
	inits = p;
}

void ScriptModule::init(void)
{
	while(inits)
	{
		(inits->handler)();
		inits = inits->next;
	}
}

void ScriptModule::addPreparse(const char *token, Script::Parse handler)
{
	Script::PreParse *p = new Script::PreParse;
	p->id = token;
	p->parse = handler;
	p->next = preparse;
	preparse = p;
}

void ScriptInterp::addFunction(const char *id, unsigned args, Script::Function handler)
{
        Script::Fun *rf = new Script::Fun;
        rf->id = id;
	rf->args = args;
	rf->fn = handler;
        rf->next = ifun;
        ifun = rf;
}

void ScriptInterp::addConditional(const char *id, Script::Cond handler)
{
	Script::Test *rt = new Script::Test;

	rt->id = id;
	rt->handler = handler;
	rt->next = test;
	test = rt;
}

void ScriptInterp::addAttribute(const char *id, Script::Meta handler)
{
	Script::Attr *ra = new Script::Attr;

	ra->id = id;
	ra->meta = handler;
	ra->next = attr;
	attr = ra;
}

ScriptModule *ScriptModule::find(const char *name)
{
	ScriptModule *mod = first;
	char keybuf[33];
	unsigned len = 0;

	while(*name && *name != '.' && len < sizeof(keybuf) - 1)
		keybuf[len++] = *(name++);

	keybuf[len] = 0;

	while(mod)
	{
		if(!stricmp(keybuf, mod->cmd))
			return mod;
		mod = mod->next;
	}
	return mod;
}

Script::Package::Package(const char *name) :
DSO(name)
{
	filename = newString(name);
	next = first;
	first = this;
}

bool Script::use(const char *name)
{
	Package *pkg = Package::first;
	char buffer[256];
	const char *dpath = Process::getEnv("BAYONNE_LIBRARY");

	// test "shell" runs local modules
	if(strchr(name, '/'))
		return false;

#ifdef	WIN32
	if(strchr(name, '\\'))
		return false;

	if(!dpath || !*dpath)
		snprintf(buffer, sizeof(buffer), "../w32/Modules/%s.rll", name);
	else
		snprintf(buffer, sizeof(buffer), "%s/modules/%s.rll", dpath, name);

#else
	if(!dpath || !*dpath)
		snprintf(buffer, sizeof(buffer), "../modules/script/%s.dso", name);
	else
		snprintf(buffer, sizeof(buffer), "%s/modules/%s.dso", dpath, name);
#endif

	name = buffer;

	while(pkg)
	{
		if(!strcmp(pkg->filename, name))
			return true;
		pkg = pkg->next;
	}

	if(!canAccess(name))
	{
		slog.error() << "use: cannot find " << name << std::endl;
		return false;
	}

#ifdef	CCXX_EXCEPTIONS
	try
	{
		new Package(name);
	}
	catch (DSO *dso)
	{
		slog.error() << "use: cannot load " << name << std::endl;
		delete dso;
		return false;
	}
#else
	pkg = new Package(name);
	if(!pkg->isValid())
	{
		slog.error() << "use: cannot load " << name << std::endl;
		delete pkg;
		return false;
	}	
#endif
	return true;
}

#ifdef	CCXX_NAMESPACES
}
#endif
