%% Copyright (C) 2000-2001 Open Source Telecom Corporation.
%%
%% This file is free software; as a special exception the author gives
%% unlimited permission to copy and/or distribute it, with or without
%% modifications, as long as this notice is preserved.
%%
%% This program is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY, to the extent permitted by law; without even the
%% implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
%%
%% This program manages the generic prompts and demonstrates how to use
%% record.bm.

	%% bind script to [playrec] in apps.conf!
	%% (virtual hosted also use virtual/virtname.conf)
	%% default values for unset keys can also be specified...

	config	retries 3	%% number of retries 
	config	help 0		%% help level
	config	timeout 10s	%% timeout for input
	config	maxtime 60s	%% maximum record size

        requires record         %% dont import since we override retries
	use files		%% we need file manipulation commands...
	dir prompts		%% create prompts directory compile-time

	%% initialize some variables...

	const .tempname "tmp:playrec" %tsid
	counter .retry
	size 3 .msg

program	main
	answer
	clear %session.digits
	play playrec0  %% enter 3 digit prompt to modify
	sleep $timeout
	if .retry >= $retries then goto @inactive
	restart

@inactive
	play playrec3 goodbye
	hangup

^0
	play thankyou goodbye
	hangup

^dtmf
	collect count=3 ignore="*#ABCD" var=>.msg timeout=$timeout
	begin
	case .msg.len = 0
		restart
	case .msg.len < 3
		play playrec2	%% invalid
		restart
	case -prompt .msg prefix=prompts
		build .tempname playrec1 &spell .msg
		record::replace timeout=$timeout file=.msg maxtime=$maxtime \
			name=.tempname retries=$retries help=$help
		erase temp/playrec
		restart .retry="0"	
	endcase
	build .tempname playrec1 &spell .msg
	record::initial timeout=$timeout file=.msg maxtime=$maxtime \
		name=.tempname retries=$retries help=$help
	erase .tempname
	restart .retry="0"

^hangup
	erase .tempname	%% cleanup our temporary
	exit


