// Copyright (C) 2000-2003 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne
// with the OpenH323 and Pwlib libraries, and distribute the combination, 
// without applying the requirements of the GNU GPL to the OpenH323
// and pwd libraries as long as you do follow the requirements of the 
// GNU GPL for all the rest of the software thus combined.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include "driver.h"

#ifdef CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

bool OH323Trunk::joinHandler(TrunkEvent *event)
{
	TrunkEvent jevent;
	const char *cp;
	struct tm *dt, tbuf;
	struct stat ino;
	char buffer[32];
	const char *ext;
	char *fn;
	Audio::Info info;
	time_t now;
	char dbuf[12];

	switch(event->id)
	{
	case TRUNK_STOP_STATE:
		data.join.count = 0;
		if(joined && joined->getJoined())
			Part();
		TimerPort::endTimer();
		//stopChannel
		_stopping_state = true;
		//delete softJoin;
		//softJoin = NULL;
step:
		if(data.join.start)
		{
			time(&now);
			now -= data.join.start;
			snprintf(dbuf, sizeof(dbuf), "%ld", now);
			setSymbol(SYM_JOINDURATION, dbuf);
		}
		handler = &OH323Trunk::stepHandler;
		return true;
	case TRUNK_TIMER_EXPIRED:
		if(data.join.count)
		{
			--data.join.count;
			if(data.join.trunk->getSequence() != data.join.seq)
				goto failed;
			goto retry;
		}
		if(joined && joined->getJoined())
			Part();
		//stopChannel(EV_ASYNC);
		if(!trunkSignal(TRUNK_SIGNAL_TIMEOUT))
			trunkSignal(TRUNK_SIGNAL_STEP);
		goto step;
	case TRUNK_ENTER_STATE:
		setSymbol(SYM_JOINDURATION, "");
		data.join.start = 0;
retry:
		TimerPort::endTimer();
		//if(softJoin == NULL)
		//	softJoin = new AudioBuffer();

		if(data.join.trunk)
		{
			slog(Slog::levelDebug) << "data join trunk is there" << endl;
			jevent.id = TRUNK_JOIN_TRUNKS;
			jevent.parm.trunk = this;
			jevent.parm.ok = data.join.local;

			data.join.trunk->postEvent(&jevent);
			if(!joined && data.join.count)
			{
	                      	enterState("sync");
                               	status[tsid] = 's';
                               	setTimer(keythreads.getResetDelay());
                                	return true;
			}
			if(!joined && jevent.parm.trunk == NULL)
			{
failed:
				trunkError("join-failed");
				handler = &OH323Trunk::stepHandler;
				return true;
			}
			data.join.count = 0;
			enterState("join");
			status[tsid] = 'j';
			Join((Trunk*)joined);
			time(&data.join.start);
			return true;
		}
		else
		{
			data.join.count = 0;
			Trunk::setDTMFDetect();
			enterState("wait");
			status[tsid] = 'w';
		}
		if(data.join.wakeup)
			TimerPort::setTimer(data.join.wakeup);
		return true;
	case TRUNK_AUDIO_IDLE:
		return true;
	case TRUNK_PART_TRUNKS:
		stopChannel(AUDIO_BOTH);
		TimerPort::endTimer();
		if(data.join.hangup)
		{
			if(!trunkSignal(TRUNK_SIGNAL_CANCEL))
				trunkSignal(TRUNK_SIGNAL_HANGUP);
		}
		else
			if(!trunkSignal(TRUNK_SIGNAL_CANCEL))
				Trunk::error("join-parted");
		goto step;
	case TRUNK_SIGNAL_JOIN:
		if(joined)
			return false;

		if(event->parm.error)
			setSymbol(SYM_ERROR, event->parm.error);
		else
			event->parm.error = "";

		if(!trunkSignal(TRUNK_SIGNAL_EVENT))
			trunkSignal(TRUNK_SIGNAL_HANGUP);
		else
		{
			setSymbol(SYM_EVENTID, "join");
			setSymbol(SYM_EVENTMSG, event->parm.error);
		}
		goto step;
	case TRUNK_JOIN_TRUNKS:
		if(joined)
			return false;

		if(data.join.waiting)
		{
			if(event->parm.trunk != data.join.waiting)
				return false;
		}

		data.join.count = 0;
		//stopChannel(EV_ASYNC);
		TimerPort::endTimer();

		if(Join(event->parm.trunk))
		{
			time(&data.join.start);
			((OH323Trunk *)event->parm.trunk)->Join((Trunk*)this);
			cp = joined->getSymbol(SYM_GID);
			setSymbol(SYM_JOINID, strchr(cp, '-'));
			return true;
		}

		trunkError("join-failed");
		handler = &OH323Trunk::stepHandler;
		return false;
	}
	return false;
}

#ifdef CCXX_NAMESPACES
}
#endif

