// Copyright (C) 2000-2003 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne
// with the OpenH323 and Pwlib libraries, and distribute the combination, 
// without applying the requirements of the GNU GPL to the OpenH323
// and pwd libraries as long as you do follow the requirements of the 
// GNU GPL for all the rest of the software thus combined.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include "driver.h"

#ifdef CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

bool OH323Trunk::recordHandler(TrunkEvent *event)
{
	char *fn;
	struct tm *dt, tbuf;
	struct stat ino;
	char buffer[32];
	const char *ext;
	const char *fmt = data.record.encoding;
	Audio::Info info;
	unsigned mask;
	int rtn;

	switch(event->id)
	{
	case TRUNK_STOP_STATE:
		_stopping_state = true;
	case TRUNK_TIMER_EXPIRED:
		endTimer();
		if(!stopChannel(AUDIO_RECEIVE))
			handler = &OH323Trunk::stepHandler;
		return true;
	case TRUNK_AUDIO_IDLE:
		endTimer();
		handler = &OH323Trunk::stepHandler;
		if(_stopping_state == false)
		{
			trunkSignal(TRUNK_SIGNAL_STEP);
		}
		endRecord();
		return true;
	case TRUNK_DTMF_KEYUP:
		if(!getExitkey(data.record.term, event->parm.dtmf.digit))
			return false;
		endTimer();
		if(!stopChannel(AUDIO_RECEIVE))
			handler = &OH323Trunk::stepHandler;
		return true;
	case TRUNK_ENTER_STATE:
		enterState("record");
		status[tsid] = 'r';
		_stopping_state = false;
		setTimer(data.record.timeout);
		
		if(data.record.term)
			Trunk::setExitkey();
		else
			Trunk::setDTMFDetect();
		getName(buffer);

		ext = strrchr(data.record.name, '/');
		if(!ext)
			ext = data.record.name;

		ext = strrchr(ext, '.');
		
		info.format = riff;
		info.order = __LITTLE_ENDIAN;
		info.encoding = pcm16Mono;
		info.order = 0;
		info.annotation = NULL;
		info.rate = 8000;

		if(!ext)
		{
			ext = data.record.extension;
			strcat(data.record.name, ext);
		}

		if(!fmt)
			fmt = "pcm";

		AudioFile::close();

		if(stricmp(fmt, "pcm") && stricmp(fmt, "raw") && stricmp(fmt, "linear"))
		{
			setSymbol(SYM_RECORDED, "0");
			setSymbol(SYM_OFFSET, "0");
			slog(Slog::levelError) << buffer << ": unsupported encoding requested" << endl;			
			trunkError("record-failed");
			handler = &OH323Trunk::stepHandler;
			return true;			
		}

		if(data.record.annotation[0])
			info.annotation = (char *)data.record.annotation;

		if(data.record.offset != (unsigned long)-1)
		{
			open(data.record.name, modeWrite);
			setPosition(data.record.offset);
		}
		else if(data.record.append)
			open(data.record.name, modeWrite);
		else
			create(data.record.name, &info);

		info.annotation = NULL;
		setSymbol(SYM_RECORDED, "0");

		if(!isOpen())
		{
			slog(Slog::levelError) << data.record.name << ": cannot open" << endl;
			setSymbol(SYM_OFFSET, "0");
			trunkError("record-failed");
			handler = &OH323Trunk::stepHandler;
			return true;
		}

		if(data.record.append)
			setPosition();

		dt = localtime_r(&ino.st_ctime, &tbuf);
		sprintf(buffer, "%04d%02d%02d,%02d%02d%02d",
			dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday,
			dt->tm_hour, dt->tm_min, dt->tm_sec);
		setSymbol(SYM_CREATED, buffer);
		fn = getAnnotation();
		if(fn)
			setSymbol(SYM_ANNOTATION, fn);
		else
			setSymbol(SYM_ANNOTATION, "");

		if(data.record.info)
		{
			sprintf(buffer, "%ld", getPosition());
			setSymbol(SYM_OFFSET, buffer);
		}

		if(lockConnection())
		{
			conn->receive = new AudioFileChannel((AudioFile *)this);
			conn->channel->attachReceiver(conn->receive);
			releaseConnection();
		}
		else
		{
			trunkError("record-failed");
			handler = &OH323Trunk::stepHandler;
		}
		return true;
	}
	return false;
}

#ifdef CCXX_NAMESPACES
}
#endif

