// Copyright (C) 2000-2003 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne
// with the OpenH323 and Pwlib libraries, and distribute the combination, 
// without applying the requirements of the GNU GPL to the OpenH323
// and pwd libraries as long as you do follow the requirements of the 
// GNU GPL for all the rest of the software thus combined.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include "driver.h"

#ifdef CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

bool OH323Trunk::ringHandler(TrunkEvent *event)
{
	char script[256];
	int argc = 0;
	char *args[2];
	char **start = NULL;
	const char *data;
	const char *value;
	TrunkGroup *grp = NULL;

	//slog(Slog::levelDebug) << event->id << endl;
	switch(event->id)
	{
	case TRUNK_ENTER_STATE:
		enterState("ring");
		status[tsid] = '!';

		if(!grp)
			grp = group;
		start = getInitial(args);
		if(attach(*start))
		{
			setList(++start);
			handler = &OH323Trunk::stepHandler;
			return true;
		}
		rings = 0;
		getName(script);
		slog(Slog::levelError) << script<< ": cannot answer call" << endl;	
		return true;
	case TRUNK_START_SCRIPT:
		return false;
	case TRUNK_STOP_DISCONNECT:
	case TRUNK_TIMER_EXPIRED:
		Trunk::flags.dsp = DSP_MODE_INACTIVE;
		handler = &OH323Trunk::hangupHandler;
		return true;
	}
	return false;
}

#ifdef CCXX_NAMESPACES
}
#endif

