// Copyright (C) 2000 Open Source Telecom Corporation.
// Copyright (C) 2004 Free Software Foundation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "bayonneserver.h"

#ifndef DEBUG
#define DEBUG() slog(Slog::levelDebug) << __FILE__ << ":" << __LINE__ << " " << __PRETTY_FUNCTION__ << endl;
#endif

#include "rtp.h"
#include "sip.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

class SIPTrunk;
class SIPDriver;

extern SIPDriver sipivr;

/*
 * The SIPTrunk class implements the glue between an
 * RTPTrunk and the SIP signalling layer. The RTPTrunk
 * class purposefully leaves the answerHandler, 
 * dialHandler, hangupHandler, and stepHandler undefined
 * since they require signalling knowledge. So it is here
 * that they are defined.
 */
class SIPTrunk : private RTPTrunk
{
 private:
    friend class SIPDriver;
    friend class SIPPlay;

    int callId;
    int dialogId;

    SIPTrunk(int ts);
    ~SIPTrunk();

    bool answerHandler(TrunkEvent *event);
    bool dialHandler(TrunkEvent *event);
    bool hangupHandler(TrunkEvent *event);
    bool stepHandler(TrunkEvent *event);

    // unused?
    bool toneHandler(TrunkEvent *event);
    bool busyHandler(TrunkEvent *event);
    bool seizeHandler(TrunkEvent *event);
    bool waitHandler(TrunkEvent *event);
    bool loadHandler(TrunkEvent *event);
    bool flashonHandler(TrunkEvent *event);
    bool flashoffHandler(TrunkEvent *event);

    void setCallId(int cid)
	{ callId = cid; };
    void setDialogId(int did)
	{ dialogId = did; };

 public:
    Driver *getDriver(void)
	{ return (Driver *)&sipivr; };
};

class SIPConfig : public Keydata
{
public:
	SIPConfig();

	inline int getCount(void)
		{ return atoi(getLast("count")); };

	size_t getStack(void);
	size_t getAudioStack(void);
};

class SIPDriver : public Driver, public SIPConfig,
		  public Thread, public SIPUserAgent
{
private:

	int start(void);
	void stop(void);
	void run(void);

	SIPTrunk **ports;
	unsigned port_count;
	Mutex portMutex;

public:
	SIPDriver();
	~SIPDriver();

	unsigned getTrunkCount(void) 
	    { return atoi(getLast("count")); };
	Trunk *getTrunkPort(int id);
	Trunk *getTrunkCallId(int callid);
	Trunk *getTrunkUnused(int callid);
	bool setTrunkDialogId(Trunk *trunk, int did) {
	    if(!trunk || !isTrunkClass(trunk->getId(), "rtp")) 
		return false;
	    ((SIPTrunk *)trunk)->dialogId = did;
	    return true;
	}

	//
	// set the local address to be used for
	// our RTP audio stream
	//
	bool setTrunkLocalAddress(Trunk *trunk, InetHostAddress ha) {
	    if(!trunk || !isTrunkClass(trunk->getId(), "rtp"))
		return false;
	    ((RTPTrunk *)trunk)->setLocalAddress(ha);
	}
	
	// 
	// set the RTP destination of our audio
	// stream
	//
	bool setTrunkDestination(Trunk *trunk, InetHostAddress ha, tpport_t hp) {
	    if(!trunk || !isTrunkClass(trunk->getId(), "rtp")) 
		return false;
	    ((RTPTrunk *)trunk)->setRemoteAddress(ha, hp);
	    return true;
	}
	void deleteTrunk(Trunk *trunk);
	bool isTrunkClass(int id, const char *name);
	aaScript *getScript(void);
//	void notify(unsigned char id);    // ALWAYS trunk + 1

	Driver *getDriver(void)
		{return (Driver *)&sipivr;};

	char *getName(void)
		{return "sip";};
};

#ifdef	CCXX_NAMESPACES
};
#endif
