// Copyright (C) 2000 Open Source Telecom Corporation.
// Copyright (C) 2004 Free Software Foundation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

bool RTPTrunk::idleHandler(TrunkEvent *event)
{
    char script[256];
    int argc = 0;
    const char *start = NULL;
    const char *caller = NULL;
    const char *value;
    unsigned chk = 0;
    char **argv;

    switch(event->id) {
    case TRUNK_ENTER_STATE:
	exittimer = synctimer = 0;
	enterState("idle");
	setIdle(true);
	ScriptSymbol::purge();
	tgi.pid = 0;
	digits = 0;
	switch(Trunk::flags.trunk) {
	case TRUNK_MODE_OUTGOING:
	    decOutgoing();
	    break;
	case TRUNK_MODE_INCOMING:
	    decIncoming();
	}

	Trunk::flags.trunk = TRUNK_MODE_INACTIVE;
	Trunk::flags.dsp = DSP_MODE_INACTIVE;
	Trunk::flags.ready = true;
	Trunk::flags.offhook = false;
	status[tsid] = '-';
	time(&idletime);
	rings = 0;
	endTimer();
	return true;
    case TRUNK_LINE_WINK:
    case TRUNK_CPA_DIALTONE:
    case TRUNK_MAKE_IDLE:
    case TRUNK_STOP_DISCONNECT:
	return true;
	// case TRUNK_MAKE_BUSY:
	// endTimer();
	//	handler = &SIPTrunk::busyHandler;
	// return true;
    case TRUNK_TIMER_EXPIRED:
	flags.ready = true;
	return true;		
    case TRUNK_START_SCRIPT:
	Trunk::flags.trunk = TRUNK_MODE_OUTGOING;
    case TRUNK_RING_START:
	start = event->parm.argv[0];
	if(start) {
	    if(strchr(start, '='))
		start = NULL;
	    else
		++argc;
	}

	if(start) {
	    slog(Slog::levelInfo) << "callee info: " << start << endl;
	    setConst(SYM_DIALED, start);
	}
	caller = event->parm.argv[1];
	if (caller)
	  {
	    slog(Slog::levelInfo) << "caller info: " << caller << endl;
	    setConst(SYM_CALLER, caller);
	  }

	if(Trunk::flags.trunk == TRUNK_MODE_INACTIVE)
	    Trunk::flags.trunk = TRUNK_MODE_INCOMING;
	rings = 0;
	if(attach(start)) {
	    setList(&event->parm.argv[argc]);
	    flags.ready = false;
	    endTimer();
	    syncParent("start:running");
	    handler = &RTPTrunk::stepHandler;
	    if(Trunk::flags.trunk == TRUNK_MODE_OUTGOING)
		incOutgoing();
	    else
		incIncoming();
	    return true;
	}
	syncParent("start:failed");
	ScriptSymbol::purge();
	flags.trunk = TRUNK_MODE_INACTIVE;
	slog(Slog::levelError) << start << ": cannot start" << endl;
	return false;
    case TRUNK_RING_REDIRECT:
	setConst(SYM_REDIRECT, event->parm.argv[0]);
	rings = 0;
	if(attach(start)) {
	    setList(&event->parm.argv[1]);
	    flags.ready = false;
	    flags.trunk = TRUNK_MODE_INCOMING;
	    endTimer();
	    handler = &RTPTrunk::stepHandler;
	    incIncoming();		
	    return true;
	}
	ScriptInterp::purge();
	slog(Slog::levelError) << event->parm.argv[0] << ": unable to redirect" << endl;
	return true;
    case TRUNK_RINGING_ON:
	if(!group->getAnswer())
	    return true;
	rings = 1;
	flags.trunk = TRUNK_MODE_INCOMING;
	incIncoming();
	flags.ready = false;
	endTimer();
	handler = &RTPTrunk::ringHandler;
	return true;
    }
    return false;
}

#ifdef	CCXX_NAMESPACES
};
#endif
