// Copyright (C) 2000-2003 Open Source Telecom Corporation.
// Copyright (C) 2004 Free Software Foundation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif
    
bool RTPTrunk::Join(Trunk *trk)
{
    DEBUG();
    slog(Slog::levelDebug) << id << " Join()" << endl;
    if(!trk)
	return false;
    return true;
}

bool RTPTrunk::joinHandler(TrunkEvent *event)
{
    TrunkEvent jevent;
    char *cp;

    DEBUG();
    slog << "joinHandler: event->id = " << event->id << endl;

    switch(event->id)
	{
	case TRUNK_TIMER_EXPIRED:
	    DEBUG();
	    if(!trunkSignal(TRUNK_SIGNAL_TIMEOUT))
		trunkSignal(TRUNK_SIGNAL_STEP);
	    handler = &RTPTrunk::stepHandler;
	    return true;
	case TRUNK_ENTER_STATE:
	    setSymbol(SYM_JOINDURATION, "");
	    data.join.start = 0;

	    endTimer();

	    DEBUG();

	    if(data.join.trunk)
		{
		    char buffer[32];
		    DEBUG();
		    data.join.trunk->getName(buffer);
		    slog << "data join trunk is " << buffer << endl;
		    slog << "and we are" << buffer << endl;

		    jevent.id = TRUNK_JOIN_TRUNKS;
		    jevent.parm.trunk = this;
		    jevent.parm.ok = data.join.local;
		    
		    data.join.trunk->postEvent(&jevent);

		    if(!joined && data.join.count)
			{
			    DEBUG();
			    enterState("sync");
			    status[tsid] = 's';
			    setTimer(keythreads.getResetDelay());
			    return true;
			}
		    if(!joined && jevent.parm.trunk == NULL)
			{
			    DEBUG();
			    trunkError("join-failed");
			    handler = &RTPTrunk::stepHandler;
			    return true;
			}
		    DEBUG();
		    data.join.count = 0;
		    enterState("join");
		    status[tsid] = 'j';
		    Join((Trunk *)joined);
		    time(&data.join.start);
		    return true;
		}
	    else
		{
		    DEBUG();
		    data.join.count = 0;
		    setDTMFDetect();
		    enterState("wait");
		    status[tsid] = 'w';
		}
	    
	    DEBUG();
	    if(data.join.wakeup)
		setTimer(data.join.wakeup);
	    return true;
	case TRUNK_JOIN_TRUNKS:
	    DEBUG();
	    slog(Slog::levelDebug) << id << ": TRUNK_JOIN_TRUNKS" << endl;
	    if(joined)
		return false;

	    DEBUG();
	    if(data.join.waiting)
		if(event->parm.trunk != data.join.waiting)
		    return false;

	    DEBUG();
	    data.join.count = 0;
	    if(Join(event->parm.trunk))
		{
		    DEBUG();
		    time(&data.join.start);
		    ((RTPTrunk *)event->parm.trunk)->Join((Trunk *)this);
		    cp = joined->getSymbol(SYM_GID);
		    setSymbol(SYM_JOINID, strchr(cp, '-'));
		    return true;
		}
	    DEBUG();
	    trunkError("join-failed");
	    handler = &RTPTrunk::stepHandler;
	    return false;
	}
    return false;
}

#ifdef CCXX_NAMESPACES
};
#endif

