// Copyright (C) 2000 Open Source Telecom Corporation.
// Copyright (C) 2004 Free Software Foundation
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
using namespace std;
namespace ost {
#endif

bool RTPTrunk::playFromFile(void)
{
    char buffer[33];
    struct stat ino;
    struct tm *dt;
    struct tm tbuf;
    char *ann;
    AudioStreamFile *af = new AudioStreamFile();

    char *fn;

    getName(buffer);

    //
    // synthesize the audio file if necessary
    //
    if(TTS::ttsFirst)
	if(!TTS::ttsFirst->synth(getId(), &data)) 
	    {
		delete af;
		trunkError("rtp-tts-error");
		return false;
	    }

	if(data.play.mode == PLAY_MODE_NONE)
	{
		trunkSignal(TRUNK_SIGNAL_STEP);
		handler = &RTPTrunk::stepHandler;
		return true;
	}		
    
    trunk = this;
    fn = getPlayfile();
    
 retry:
    if(!fn) 
	{
	    if(data.play.lock) 
		{
		    cachelock.unlock();
		    data.play.lock = false;
		}
	    if(data.play.mode == PLAY_MODE_ANY)
		return true;

	    //
	    // Here we have no file to play. Either it
	    // is an error on the script-writer's part,
	    // or we have come to the end of the list of
	    // things to play. We do not treat this as an
	    // error, instead, having finished doing all
	    // that we can do, we return to the stepHandler
	    //
	    handler = &RTPTrunk::stepHandler;
	    trunkSignal(TRUNK_SIGNAL_STEP);
	    return true;
	}

    // 
    // open the file and lseek to the proper  place
    //
    ::stat(fn, &ino);
    af->open(fn, AudioFile::modeRead);
    if(data.play.lock) {
	cachelock.unlock();
	data.play.lock = false;
    }
    if(!af->isOpen()) {
	if(data.play.mode == PLAY_MODE_ANY || data.play.mode == PLAY_MODE_ONE)
	    goto retry;
	errlog("missing", "Prompt=%s", fn);
	slog(Slog::levelError) << buffer << ": " << fn << ": cannot open" << endl;
	delete af;
	trunkError("rtp-open-file");
	return false;
    }

    if(data.play.mode == PLAY_MODE_TEMP)
	::remove(fn);
    if(data.play.offset)
    	af->setPosition(data.play.offset);
    // if(data.play.limit)
    // setLimit(data.play.limit);

    //
    //  save information for the script interpreter
    //
    dt = localtime_r(&ino.st_ctime, &tbuf);
    sprintf(buffer, "%04d%02d%02d,%02d%02d%02d",
	    dt->tm_year + 1900, dt->tm_mon + 1, dt->tm_mday,
	    dt->tm_hour, dt->tm_min, dt->tm_sec);

    setSymbol(SYM_CREATED, buffer);
    ann = af->getAnnotation();
    if(ann)
	setSymbol(SYM_ANNOTATION, ann);
    else
	setSymbol(SYM_ANNOTATION, "");

    //
    // glue the file to the rtp stream as a
    // source
    //
    enterMutex();
    playFile = af;
    rtpStream->setSource(playFile);
    leaveMutex();

    //
    // find how long it would take to play the
    // whole file, and set the timer to the
    // minimum of that value, or the maximum
    // timeout.
    // 
    timeout_t playtime = 1000 * af->toSamples(af->getEncoding(), ino.st_size) / af->getSampleRate();
    setTimer((data.play.maxtime && (data.play.maxtime < playtime)) 
	     ? data.play.maxtime : playtime);
    return true;
}

    /*
     * 
     */
bool RTPTrunk::playHandler(TrunkEvent *event)
{
    switch(event->id) 
	{
        case TRUNK_DTMF_KEYUP:
            if(!getExitkey(data.play.term, event->parm.dtmf.digit))
                return false;
                if(digits < MAX_DIGITS)
                      dtmf.bin.data[digits++] = digit[event->parm.dtmf.digit];
                dtmf.bin.data[digits] = 0;

	    trunkSignal(TRUNK_SIGNAL_STEP);
            // fall through

	case TRUNK_STOP_STATE:
	    enterMutex();
	    if(playFile) {
		rtpStream->setSource(NULL);
		delete playFile;
		playFile = NULL;
		leaveMutex();
	    }
	    leaveMutex();
	    handler = &RTPTrunk::stepHandler;
	    return true;
	case TRUNK_ENTER_STATE:
                if(hasExitMask(data.play.term))
                {
                        trunkSignal(TRUNK_SIGNAL_STEP);
                        handler = &RTPTrunk::stepHandler;
                        return true;
                }

	    enterState("play");
	    flags.dsp = DSP_MODE_VOICE;
	    status[tsid] = 'p';
	    if(data.play.text)
		// send instant message...
		;

	    // FALL THROUGH
	case TRUNK_TIMER_EXPIRED:
	    // if playfile, that means that the
	    // timer expired and we have just
	    // finishd playing the file.
	    enterMutex();
	    if(playFile) {
		rtpStream->setSource(NULL);
		delete playFile;
		playFile = NULL;
	    }
	    leaveMutex();
	    
	    if(!rtpActive()) 
		{
		    trunkError("play-no-rtp");
		    trunkSignal(TRUNK_SIGNAL_STEP);
		    handler = &RTPTrunk::stepHandler;
		    return true;
		}
	
	    setDTMFDetect();
	    
	    if(!playFromFile()) 
		{
		    trunkSignal(TRUNK_SIGNAL_STEP);
		    handler = &RTPTrunk::stepHandler;
		}

	    return true;
	}
    return false;
}

bool RTPTrunk::playwaitHandler(TrunkEvent *event)
{
    DEBUG();
    switch(event->id)
	{
        case TRUNK_EXIT_SHELL:
	    if(!tgi.pid)
		return true;
	    tgi.pid = 0;
	    endTimer();
	    if(event->parm.status)
                {
		    sprintf(buffer, "play-failed-exit-%d",
			    event->parm.status);
		    trunkError(buffer);
		    handler = &RTPTrunk::stepHandler;
		    return true;
                }
	    handler = &RTPTrunk::playHandler;
	    return true;  
	    
        case TRUNK_TIMER_EXPIRED:
	    if(tgi.pid)
                {
		    kill(tgi.pid, SIGTERM);
		    tgi.pid = 0;
                }
	    trunkError("play-failed-timeout");
	    handler = &RTPTrunk::stepHandler;
	    return true;                                                     
	    
	case TRUNK_ENTER_STATE:
	    enterState("playwait");
	    endTimer();
	    setDTMFDetect();
	    setTimer(data.play.timeout);
	    return true;
        }
    return false;                                                            
}

#ifdef	CCXX_NAMESPACES
};
#endif
