// Copyright (C) 2000 Open Source Telecom Corporation.
// Copyright (C) 2004 Free Software Foundation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

    /*
     * The step handler is the main engine of
     * the SIP trunk type. It was declared as 
     * virtual by RTPTrunk, our parent class,
     * so that we may define it here in a way
     * that enables us to interact with the SIP
     * UserAgent implementation.
     */
bool SIPTrunk::stepHandler(TrunkEvent *event)
{
    SIPUserAgent *ua = (SIPUserAgent *)getDriver();
    Trunk *alt = ctx;
    char buf[256];

    switch(event->id) {
    case TRUNK_MAKE_STEP:
	if(idleHangup())
	    return true;
	switch(event->parm.step) {
	case TRUNK_STEP_THREAD:
	    handler = &RTPTrunk::threadHandler;
	    return true;
	case TRUNK_STEP_SLEEP:
	    handler = &RTPTrunk::sleepHandler;
	    return true;
	case TRUNK_STEP_JOIN:
	case TRUNK_STEP_SOFTJOIN:
	    handler = &RTPTrunk::joinHandler;
	    return true;
	case TRUNK_STEP_HANGUP:
	    handler = &RTPTrunk::hangupHandler;
	    return true;
	case TRUNK_STEP_ANSWER:
	    // initialize our RTP handling
	    // threads
	    if(!rtpStart()) {
		ua->answer(dialogId, 504, 0);
		return false;
	    }

	    // cause the agent to answer the 
	    // call
	    ua->answer(this->dialogId, 200, RTPTrunk::getLocalPort());
	    trunkSignal(TRUNK_SIGNAL_STEP);
	    handler = &RTPTrunk::stepHandler;
	    return true;
	case TRUNK_STEP_COLLECT:
	    handler = &RTPTrunk::collectHandler;
	    return true;
	case TRUNK_STEP_FLASH:
	    trunkSignal(TRUNK_SIGNAL_STEP);
	    handler = &RTPTrunk::stepHandler;
	    return true;
	case TRUNK_STEP_PLAY:
	    handler = &RTPTrunk::playHandler;
	    return true;
	    //	case TRUNK_STEP_TONE:
	    //	    handler = &RTPTrunk::toneHandler;
	    //	    return true;
	case TRUNK_STEP_RECORD:
	    handler = &RTPTrunk::recordHandler;
	    return true;
	    //	case TRUNK_STEP_DIALXFER:
	    //	    handler = &RTPTrunk::dialHandler;
	    //	    return true;
	case TRUNK_STEP_PLAYWAIT:
	    handler = &RTPTrunk::playwaitHandler;
	    return true;
	}
	Trunk::trunkError("step-invalid");
	return true;
    case TRUNK_SERVICE_SUCCESS:
    case TRUNK_SERVICE_FAILURE:
	endTimer();
	setTimer(keythreads.getResetDelay());
	return true;
    case TRUNK_STOP_STATE:
    case TRUNK_TIMER_EXPIRED:
	flags.reset = false;
	stopServices();
    case TRUNK_ENTER_STATE:
	flags.offhook = true;
	if(flags.trunk == TRUNK_MODE_OUTGOING)
	    status[tsid] = 'o';
	else
	    status[tsid] = 'i';
	
	setDTMFDetect();
	endTimer();
	strcpy(numbers[5].sym.data, "step");
	debug->debugStep(this, getScript());
	if(alt != this)
	    alt->enterMutex();
	scriptStep();
	if(alt != this)
	    alt->leaveMutex();
	if(handler == &RTPTrunk::stepHandler)
	    TimerPort::setTimer(keythreads.getStepDelay());
	return true;
    }	
    return false;
}

#ifdef	CCXX_NAMESPACES
};
#endif
