// Copyright (C) 2000 Open Source Telecom Corporation.
// Copyright (C) 2004 Free Software Foundation
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

SIPTrunk::SIPTrunk(int ts) :
    RTPTrunk(ts, &sipivr)
{
    // set up audio buffer here
    // softJoin = new AudioBuffer();
    handler = &RTPTrunk::idleHandler;
    if(usage)
	setUsage(&usage->netuse);
}

SIPTrunk::~SIPTrunk()
{
    delete softJoin;
    return;
}

void RTPTrunk::exit(void)
{
    if(!flags.onexit)
	if(redirect("::exit")) 
	    {
		flags.onexit = true;
		return;
	    }
    handler = &RTPTrunk::hangupHandler;
}

unsigned long RTPTrunk::getIdleTime(void)
{
    time_t now;

    time(&now);
    if(handler == &RTPTrunk::idleHandler)
	return now - idletime;
    return 0;
}

void RTPTrunk::trunkStep(trunkstep_t step)
{
    TrunkEvent event;

    if(handler != &RTPTrunk::stepHandler)
	return;

    event.id = TRUNK_MAKE_STEP;
    event.parm.step = step;
    stepHandler(&event);
}

bool RTPTrunk::postEvent(TrunkEvent *event)
{
    bool rtn = true;
    trunkhandler_t prior;
    SIPDriver *drv;
    char evt[65];

    enterMutex();

    switch(event->id) 
	{
	case TRUNK_TIMER_EXPIRED:
	    if(getTimer() <0)
		rtn = false;
	    endTimer();
	    break;
	}

    if(!rtn) 
	{
	    leaveMutex();
	    return false;
	}

    if(!handler) 
	{
	    slog(Slog::levelWarning) << "no handler active; event=" << event->id << endl;
	    leaveMutex();
	    return false;
	}

 retry:
    prior = handler;
    rtn = (this->*handler)(event);
    if(rtn) 
	{
	    if(prior != handler) 
		{
		    event->id = TRUNK_ENTER_STATE;
		    goto retry;
		}
	    leaveMutex();
	    return true;
	}

    //
    // This case statement is the default event handler
    // it handles all events that are not claimed by a
    // specific handler above.
    //
    switch(event->id) 
	{
	case TRUNK_DTMF_KEYUP:
	    if(digits < MAX_DIGITS)
		dtmf.bin.data[digits++] = digit[event->parm.dtmf.digit];
	    dtmf.bin.data[digits] = 0;
	    snprintf(evt, sizeof(evt), "digits:%s", dtmf.bin.data);
	    if(Trunk::event(evt)) 
		{
		    event->id = TRUNK_STOP_STATE;
		    goto retry;
		}
	    if(trunkSignal((trunksignal_t)(event->parm.dtmf.digit + TRUNK_SIGNAL_0))) 
		{
		    event->id = TRUNK_STOP_STATE;
		    goto retry;
		}
	    break;
	case TRUNK_STOP_STATE:
	    endTimer();
	    handler = &RTPTrunk::stepHandler;
	    break;
	default:
	    rtn = false;
	}

    if(handler != prior)
	{
	    event->id = TRUNK_ENTER_STATE;
	    goto retry;
	}

    DEBUG();

    leaveMutex();
    return rtn;
}

#ifdef CCXX_NAMESPACES
};
#endif

