// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "bayonneserver.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

class VirtualTrunk;
class VirtualDriver;

extern VirtualDriver virtivr;

typedef	bool (VirtualTrunk::*trunkhandler_t)(TrunkEvent *event);

class VirtualTrunk : private TimerPort, private Trunk
{
private:
	friend class VirtualDriver;
	
	time_t lastring;
	trunkhandler_t handler;

	VirtualTrunk(int ts);
	~VirtualTrunk();

	void initSyms(void);
	void getName(char *buffer);
	unsigned long getIdleTime(void);
	void setHookState(bool offhook);

	bool stepHandler(TrunkEvent *event);
	bool skipHandler(TrunkEvent *event);
	bool idleHandler(TrunkEvent *event);
	bool threadHandler(TrunkEvent *event);
	bool sleepHandler(TrunkEvent *event);
	bool hangupHandler(TrunkEvent *event);

	bool postEvent(TrunkEvent *event);
	void getEvents(void);
	void setTimer(timeout_t timeout = 0);
	void incTimer(timeout_t timeout);
	void exit(void);
	void trunkStep(trunkstep_t step);

public:
	Driver *getDriver(void)
		{return (Driver*)&virtivr;};
};

class VirtualConfig : public Keydata
{
public:
	VirtualConfig();

	inline int getCount(void)
		{return atoi(getLast("count"));};

	size_t getStack(void);
};

class VirtualDriver : public Driver, public VirtualConfig, public Thread, public PortNotify
{
private:

	VirtualTrunk **ports;
	unsigned port_count;
	unsigned count;
	timeout_t step_timer;

	int start(void);
	void stop(void);
	void run(void);

public:
	VirtualDriver();
	~VirtualDriver();

	unsigned getStepTimer(void)
		{return step_timer;};

	unsigned getTrunkCount(void)
		{return port_count;};

	Trunk *getOutboundTrunk(int id);
	Trunk *getTrunkPort(int id);
	bool isTrunkClass(int id, const char *name);
	aaScript *getScript(void);
	void notify(unsigned char id);    // ALWAYS trunk + 1

	Driver *getDriver(void)
		{return (Driver *)&virtivr;};

	char *getName(void)
		{return "Virtual";};

	unsigned getCaps(void)
		{return capDaemon | capDynamic;};
};

#ifdef	CCXX_NAMESPACES
}
#endif
