// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

void VirtualTrunk::initSyms(void)
{
	setConst(SYM_INTERFACE, "virtual");
	setConst(SYM_NETWORK, "none");
}

bool VirtualTrunk::idleHandler(TrunkEvent *event)
{
	int argc = 0;
	const char *start = NULL;
	TrunkGroup *grp = NULL;

	switch(event->id)
	{
	case TRUNK_ENTER_STATE:
		synctimer = exittimer = 0;
		enterState("idle");
		setIdle(true);
		ScriptSymbol::purge();
		flags.dsp = DSP_MODE_INACTIVE;
		tgi.pid = 0;
		digits = 0;
		switch(flags.trunk)
		{
		case TRUNK_MODE_OUTGOING:
			decOutgoing();
			break;
		case TRUNK_MODE_INCOMING:
			decIncoming();
		}

		flags.trunk = TRUNK_MODE_INACTIVE;
		status[tsid] = '-';
		time(&idletime);
		purge();
		rings = 0;
		return true;
	case TRUNK_LINE_WINK:
	case TRUNK_CPA_DIALTONE:
	case TRUNK_MAKE_IDLE:
	case TRUNK_STOP_DISCONNECT:
		return true;
	case TRUNK_START_SCRIPT:
		flags.trunk = TRUNK_MODE_OUTGOING;
	case TRUNK_RING_START:
	case TRUNK_RINGING_ON:
		start = event->parm.argv[0];
		if(start)
		{
			if(strchr(start, '='))
				start = NULL;
			else
				++argc;
		}
		if(flags.trunk == TRUNK_MODE_INACTIVE)
			flags.trunk = TRUNK_MODE_INCOMING;
		rings = 0;
		if(attach(start))
		{
			setList(&event->parm.argv[argc]);
			flags.ready = false;
			endTimer();
			if(flags.trunk == TRUNK_MODE_OUTGOING)
			{
				handler = &VirtualTrunk::stepHandler;
				incOutgoing();
			}
			else
			{
				syncParent("start:running");
				handler = &VirtualTrunk::stepHandler;
				incIncoming();
			}
			return true;
		}
		syncParent("start:failed");
		ScriptSymbol::purge();
		flags.trunk = TRUNK_MODE_INACTIVE;
		slog(Slog::levelError) << "virtual/" << id << ": " << start << ": cannot start" << endl;
		return true;
	case TRUNK_RING_REDIRECT:
		setConst(SYM_REDIRECT, event->parm.argv[0]);
		rings = 0;
		if(attach(start))
		{
			setList(&event->parm.argv[1]);
			flags.ready = false;
			flags.trunk = TRUNK_MODE_INCOMING;
			endTimer();
			handler = &VirtualTrunk::stepHandler;
			incIncoming();
			return true;
		}
		ScriptInterp::purge();
		slog(Slog::levelError) << "virtual/" << id << ": " << event->parm.argv[0] << ": unable to redirect" << endl;
		return true;
	default:
		return false;
	}
}

#ifdef	CCXX_NAMESPACES
}
#endif
