// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
using namespace std;
namespace ost {
#endif


bool VPBTrunk::pickupHandler(TrunkEvent *event)
{
        switch(event->id)
        {
        case TRUNK_LINE_WINK:
        case TRUNK_STOP_DISCONNECT:
                return true;
        case TRUNK_TIMER_EXPIRED:
                handler = &VPBTrunk::stepHandler;
                return true;
        case TRUNK_ENTER_STATE:
                trunkSignal(TRUNK_SIGNAL_STEP);
                enterState("pickup");
                setTimer(getMSTimeout(vpbivr.getLast("pickup")));
                return true;
        }
        return false;
}

bool VPBTrunk::answerHandler(TrunkEvent *event)
{
	switch(event->id)
	{
	case TRUNK_LINE_WINK:
		if(!flags.offhook)
			return true;
	case TRUNK_CPA_DIALTONE:
		setSymbol(SYM_TONE, "dial");
	case TRUNK_STOP_DISCONNECT:
	case TRUNK_TIMER_EXPIRED:
		flags.dsp = DSP_MODE_INACTIVE;
		if(!Trunk::event("answer:failed"))
			trunkSignal(TRUNK_SIGNAL_HANGUP);
		handler = &VPBTrunk::stepHandler;
		return true;
	case TRUNK_ENTER_STATE:
		if(exittimer && !answered)
			exittimer = 0;
		answered = true;
		setSymbol(SYM_TONE, "none");
		if(flags.offhook)
		{
			trunkSignal(TRUNK_SIGNAL_STEP);
			handler = &VPBTrunk::stepHandler;
			return true;
		}
		status[tsid] = 'a';
		enterState("answer");

	case TRUNK_RINGING_OFF:
		if(rings > 1)
			flags.dsp = DSP_MODE_INACTIVE;

		if(data.answer.rings > rings)
		{
			setTimer(data.answer.timeout);
			return true;
		}
		endTimer();
		flags.dsp = DSP_MODE_INACTIVE;
		if(!flags.offhook)
		{
			setOffhook();
#ifdef	VPB_BAYONNEAPI
			return true;
#endif
		}
	case TRUNK_OFF_HOOK:
		status[tsid] = 'i';
		if(rings == 1 && !isStation)
		{
			handler = &VPBTrunk::pickupHandler;
			return true;
		}
		trunkSignal(TRUNK_SIGNAL_STEP);
		handler = &VPBTrunk::stepHandler;
		return true;
	case TRUNK_STATION_OFFHOOK:
		if(!isStation || !isRinging)
			return true;
		vpb_ring_station_sync(handle, VPB_RING_STATION_OFF);
		isRinging = false;
		syncParent("start:answered");
		if(!Trunk::event("answer:pickup"))
			if(!trunkSignal(TRUNK_SIGNAL_PICKUP))
				trunkSignal(TRUNK_SIGNAL_STEP);
		handler = &VPBTrunk::stepHandler;
		return true;
	}
	return false;
}

#ifdef	CCXX_NAMESPACES
};
#endif
