// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
using namespace std;
namespace ost {
#endif

void VPBTrunk::initSyms(void)
{
	char buf[4];

	snprintf(buf, sizeof(buf), "%d", _card);
	setConst(SYM_CARD, buf);
	snprintf(buf, sizeof(buf), "%d", _bank);
	setConst(SYM_BANK, buf);
	setConst(SYM_NETWORK, "soft");
	if(isStation)
	{
		setConst(SYM_TRUNKID, "0");
		setConst(SYM_INTERFACE, "station");
	}
	else
	{
		snprintf(buf, sizeof(buf), "%d", _trk);
		setConst(SYM_TRUNKID, buf);
		setConst(SYM_INTERFACE, "analog");
	}
	setSymbol(SYM_BUFFER, "12000");
}

bool VPBTrunk::idleHandler(TrunkEvent *event)
{
	char script[256];
	int argc = 0;
	const char *start = NULL;
	const char *value;
	unsigned chk;
	char **argv;
	char *stargs[2];
#ifdef	VPB_CID_MAX_DLP
	VPB_CID cid;
	char dlp[VPB_CID_MAX_DLP];
	unsigned len;
#endif
	VPBTrunk *trunk;

	switch(event->id)
	{
	case TRUNK_ENTER_STATE:
		if(isStation)
			vpb_ring_station_sync(handle, VPB_RING_STATION_OFF);
		isRinging = flags.cid = flags.sent = false;
		synctimer = exittimer = 0;
		enterState("idle");
		setIdle(true);
		tgi.pid = 0;
		digits = 0;
		answered = true;
		disjoin(TRUNK_STOP_DISCONNECT);

#ifdef	VPB_CID_MAX_DLP
		vpb_cid_set(&cid, VPB_CID_EMPTY, NULL);
		if(!isStation)
		{
                        snprintf(script, sizeof(script), "CO %d", _trk);
			vpb_cid_set(&cid, VPB_CID_CALLER_NAME, script);
                        len = vpb_cid_compose_dlp(&cid, dlp);
			cidlen = 0;
                        vpb_cid_compose_wav(dlp, len, (short *)cidbuf, &cidlen);
                        flags.cid = true;
		}
#endif

		vpb_play_set_gain(handle, outgain);
		vpb_record_set_gain(handle, inpgain);

		vpb_sethook_async(handle, VPB_ONHOOK);
		setDTMFDetect(false);
		flags.dsp = DSP_MODE_INACTIVE;
		flags.offhook = false;

		switch(flags.trunk)
		{
		case TRUNK_MODE_OUTGOING:
			decOutgoing();
			break;
		case TRUNK_MODE_INCOMING:
			decIncoming();
		}

		flags.trunk = TRUNK_MODE_INACTIVE;
		time(&idletime);
		ScriptSymbol::purge();

		status[tsid] = '-';
		rings = 0;
		return true;
	case TRUNK_STATION_FLASH:
	case TRUNK_STATION_ONHOOK:
	case TRUNK_STOP_DISCONNECT:
	case TRUNK_LINE_WINK:
	case TRUNK_CPA_DIALTONE:
	case TRUNK_MAKE_IDLE:
		return true;
	case TRUNK_MAKE_BUSY:
		endTimer();
		handler = &VPBTrunk::busyHandler;
		return true;
	case TRUNK_TIMER_EXPIRED:	
		flags.ready = true;
		return true;
#ifdef	VPB_V12PCI
	case TRUNK_STATION_OFFHOOK:
#ifdef	VPB_CID_MAX_DLP
		flags.cid = false;
#endif
		setConst(SYM_CALLTYPE, "station");
		stargs[0] = NULL;
		flags.offhook = true;
                event->parm.argv = stargs;

#endif
	case TRUNK_START_SCRIPT:
		flags.trunk = TRUNK_MODE_OUTGOING;

	case TRUNK_RING_START:
		start = event->parm.argv[0];
		if(start)
		{
			if(strchr(start, '='))
				start = NULL;
			else
				++argc;
		}
		if(flags.trunk == TRUNK_MODE_INACTIVE)
			flags.trunk = TRUNK_MODE_INCOMING;
		if(!isStation)
			rings = 0;
		if(attach(start))
		{
			setList(&event->parm.argv[argc]);
			flags.ready = false;
			endTimer();
			if(flags.trunk == TRUNK_MODE_OUTGOING)
			{
				if(event->id == TRUNK_STATION_OFFHOOK)
				{
					syncParent("start:running");
					handler = &VPBTrunk::stepHandler;
				}
				else if(isStation)
				{
					vpb_ring_station_sync(handle, VPB_RING_STATION_ON);
					syncParent("start:ringing");
					handler = &VPBTrunk::stepHandler;
					isRinging = true;
				}
				else
					handler = &VPBTrunk::seizeHandler;
				incOutgoing();
			}
			else
			{
				handler = &VPBTrunk::stepHandler;
				incIncoming();
			}
			return true;
		}
		syncParent("start:failed");
		ScriptSymbol::purge();
		flags.trunk = TRUNK_MODE_INACTIVE;
	
		return true;
	case TRUNK_RING_REDIRECT:
		setConst(SYM_REDIRECT, event->parm.argv[0]);
		if(!isStation)
			rings = 0;
		if(attach(start))
		{
			setList(&event->parm.argv[1]);
			flags.ready = false;
			flags.trunk = TRUNK_MODE_INCOMING;
			endTimer();
			handler = &VPBTrunk::stepHandler;
			incIncoming();
			return true;
		}
		ScriptInterp::purge();
		slog(Slog::levelError) << name << ": " << event->parm.argv[0] << ": unable to redirect" << endl;
		return true;
	case TRUNK_RINGING_ON:
		if(!group->getAnswer())
			return true;
		rings = 1;
		flags.trunk = TRUNK_MODE_INCOMING;
		flags.ready = false;
		endTimer();
		incIncoming();
		handler = &VPBTrunk::ringHandler;
		return true;
	}
	return false;
}

#ifdef	CCXX_NAMESPACES
};
#endif
