// Copyright (C) 2000 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "bayonneserver.h"

#ifdef  CCXX_NAMESPACES
namespace ost {
#endif

class WSSTrunk;
class WSSDriver;

extern WSSDriver wssivr;

typedef bool (WSSTrunk::*trunkhandler_t)(TrunkEvent *event);

class WSSTrunk : public Trunk, private TimerPort
{
private:
	friend class WSSDriver;
	friend class WSSPlay;
	friend class WSSRecord;
    time_t lastring;
    trunkhandler_t handler;
	char name[16];

	WSSTrunk(int ts);
	~WSSTrunk();

	void initSyms(void);
	void getName(char *buffer);
	unsigned long getIdleTime(void);
	bool threadHandler(TrunkEvent *event);
	bool toneHandler(TrunkEvent *event);
        bool stepHandler(TrunkEvent *event);
        bool busyHandler(TrunkEvent *event);
        bool idleHandler(TrunkEvent *event);
        bool seizeHandler(TrunkEvent *event);
        bool ringHandler(TrunkEvent *event);
        bool waitHandler(TrunkEvent *event);
        bool loadHandler(TrunkEvent *event);
        bool dialHandler(TrunkEvent *event);
        bool playHandler(TrunkEvent *event);
        bool playwaitHandler(TrunkEvent *event);
        bool recordHandler(TrunkEvent *event);
        bool sleepHandler(TrunkEvent *event);
        bool hangupHandler(TrunkEvent *event);
        bool answerHandler(TrunkEvent *event);
        bool collectHandler(TrunkEvent *event);
        bool flashonHandler(TrunkEvent *event);
        bool flashoffHandler(TrunkEvent *event);

	bool postEvent(TrunkEvent *event);
	void setTimer(timeout_t timeout = 0)
		{TimerPort::setTimer(timeout);};
        void exit(void);
        void trunkStep(trunkstep_t step);

protected:
	const char *getDefaultEncoding(void)
		{return "pcm";};
};

class WSSRecord : private AudioFile, public Service
{
private:
	HWAVEIN dev;
	WAVEFORMATEX fmt;
	bool reset;
	size_t bufsize, samples;

public:
	WSSRecord(WSSTrunk *trunk);
	~WSSRecord();
	void initial(void);
	void run(void);
};

class WSSPlay : private AudioFile, public Service
{
private:
		HWAVEOUT dev;
		WAVEFORMATEX fmt;
        bool reset;
        size_t bufsize, samples;
	char *getContinuation(void);

public:
        WSSPlay(WSSTrunk *trunk);
        ~WSSPlay();
        void initial(void);
        void run(void);
};

class WSSTone : private Service, private TimerPort
{
private:
	HWAVEOUT dev;
	WAVEFORMATEX fmt;
	bool reset;

	void run(void);
public:
	WSSTone(WSSTrunk *trunk);
	~WSSTone();
};

class WSSConfig : public Keydata
{
public:
	WSSConfig();

        inline int getDeviceCount(void)
                {return atoi(getLast("count"));};

        inline int getBuffers(void)
                {return atoi(getLast("buffers"));};

        size_t getStack(void);

	size_t getAudioStack(void);

};

class WSSDriver : public Driver, public WSSConfig, public Thread, public PortNotify
{
private:
	WSSTrunk **ports;
	int port_count;

public:
	WSSDriver();
	~WSSDriver();

	int start(void);
	void stop(void);

	void run(void);

	unsigned getCaps(void);

	unsigned getTrunkCount(void)
		{return 1;};

	char *getName(void)
		{return "Sound";};

	void notify(unsigned char id);

	Driver *getDriver(void)
		{return (Driver *)&wssivr;};

	Trunk *getTrunkPort(int id);
	bool isTrunkClass(int id, const char *name);
	aaScript *getScript(void);
};

#ifdef	CCXX_NAMESPACES
};
#endif
