dnl Copyright (C) 2000-2003 Open Source Telecom Corporation.
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.
dnl 
dnl OST_BAYONNE_PATH
dnl Test for Bayonne script file and set @BAYONNE@ substitution
dnl OST_BAYONNE_VERSION([MINIMUM-VERSION[,ACTION-IF-FOUND[,ACTION-IF-NOT-FOUND]]])
dnl Test for usable version of CommonC++

AC_DEFUN(OST_BAYONNE_PATH,[
	AC_PATH_PROG(BAYONNE, bayonne, no, $PATH:/usr/sbin:/usr/local/sbin:/sbin)
 	if test "$BAYONNE" != no ; then
		ost_cv_bayonne=true
		AC_SUBST(BAYONNE)
	else
		ost_cv_bayonne=false
	fi
])

AC_DEFUN(OST_BAYONNE_VERSION,
[
  AC_REQUIRE([OST_BAYONNE_PATH])
  AC_MSG_CHECKING(for bayonne version >= $bayonne_version)
  bayonne_version=ifelse([$1], ,0.99.0, $1)
  if test "$BAYONNE" = "no" ; then
    AC_MSG_RESULT(not found)
    echo "*** The bayonne installation script is missing.  You will need"
    echo "*** to install GNU Bayonne, whose later releases are available"
    echo "*** from http://www.gnu.org/software/bayonne/ and any GNU mirror."
    ifelse([$3], , :, [$3])
    exit -1
  else
    config_version=`$BAYONNE --version`
    bayonne_config_major_version=`echo $config_version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    bayonne_config_minor_version=`echo $config_version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    bayonne_config_micro_version=`echo $config_version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
           
    bayonne_check_major_version=`echo "$bayonne_version" | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    bayonne_check_minor_version=`echo "$bayonne_version" | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    bayonne_check_micro_version=`echo "$bayonne_version" | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
       
    version_ok=no       
    if test $bayonne_config_major_version -gt $bayonne_check_major_version ; then
	version_ok=yes
    elif test $bayonne_config_major_version -eq $bayonne_check_major_version  \
       && test $bayonne_config_minor_version -gt $bayonne_check_minor_version ; then
	version_ok=yes
    elif test $bayonne_config_major_version -eq $bayonne_check_major_version \
       && test $bayonne_config_minor_version -eq $bayonne_check_minor_version \
       && test $bayonne_config_micro_version -ge $bayonne_check_micro_version; then
       version_ok=yes
    fi
  
    if test "$version_ok" = "no"; then
      AC_MSG_RESULT(no)
      ost_cv_bayonne_version=false
      echo "*** An old version of Bayonne, of $config_version was found."
      echo "*** You need a version of Bayonne newer than $bayonne_version. The latest version of"
      echo "*** CommonC++ is always available from ftp://ftp.gnu.org/gnu/bayonne/."
      ifelse([$3], , :, [$3])
    else
      AC_MSG_RESULT(yes)
      ost_cv_bayonne_version=true
    fi
  fi
])

