// Copyright (C) 2000-2001 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifndef	CCXX_BAYONNEWINDOWS_H_
#include <cc++/config.h>
#ifdef	WIN32
#include "bayonnewindows.h"
#else
#include "bayonneconfig.h"
#include "bayonnepaths.h"
#endif
#endif
#include "bayonnescript.h"
#include "bayonnesymbols.h"
#include "bayonneaudio.h"
#include "bayonne.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

#ifdef	HAVE_TGI

// determine size of tgi command buffer based on atomic size of fifo,
// ideally using a fraction of a xk buffer.

#ifdef	USE_SOCKETPAIR

#define	TGI_BUF (1024)

#else

#if PIPE_BUF > 1024
#define	TGI_BUF (1024)
#else
#define	TGI_BUF	(512)
#endif

#endif

// type of tgi execution request

typedef enum
{
	TGI_EXEC_NORMAL,
	TGI_EXEC_DETACH,
	TGI_EXEC_AUDIO,
	TGI_EXEC_IMMEDIATE
} tgiexec_t;

#pragma pack(1)
typedef	struct
{
	char port[16];		// tgi port reference
	unsigned short seq;	// sequence check id
	tgiexec_t mode;		// execution mode
	char cmd[TGI_BUF - 16 - sizeof(short) - sizeof(tgiexec_t)];
} tgicmd_t;

#endif

typedef struct callrec_t
{
	char cr_time[6];
	char cr_type[5];
	char cr_caller[17];
	char cr_dialed[17];
	char cr_script[13];
	char cr_login[12];
	char cr_nl;
} callrec_t;

typedef struct {
	time_t update;
	statnode_t *buddy;
}	buddy_t;

typedef	struct {
	char grp[32];
	char scr[32];
}	schedtmp;

#pragma pack()


#ifdef	NODE_SERVICES

// the network service thread.

class Network : public Thread, public UDPSocket, public MappedFile
{
private:
	friend void broadcast(char *msgbuf, int msglen);
	friend statnode_t *getNodes(const char *name);

	statnode_t *map;
	time_t last;
	char *getPath(void);
	statnode_t *getNode(const char *name);
	statnode_t *getAddr(struct in_addr *addr);
	struct sockaddr bcast, maddr;
	struct sockaddr_in *bcast_in, *maddr_in;

	void initial(void);
	void run(void);
	void failover(void);
	void elect(void);
	void send(char *msgbuf, int msglen);

public:
	Network();

	void stop(void);
	void refresh(int secs);
};

#endif

class __EXPORT MappedCalls : public MappedFile
{
private:
	const char *getPath(void);

public:
	MappedCalls();
};

class __EXPORT MappedStats : public MappedFile
{
private:
	char *map;
	const char *getPath(void);

public:
	MappedStats();
	void scan(void);
};

class __EXPORT UsageStat : public CallStat
{
private:
	friend class MappedUsage;
	friend class Trunk;

protected:
	UsageStat() : CallStat() {maxcapacity = 0;};

	unsigned maxcapacity;

	void decCapacity(void);

	void incCapacity(void);
};

class __EXPORT MappedUsage : public MappedFile
{
private:
	char *map;
	const char *getPath(void);

public:
	UsageStat portuse, virtuse, netuse, specuse;
	MappedUsage();
	void scan(void);
	void report(void);
};	

#ifdef	NODE_SERVICES
extern Network *network;
#endif
#ifdef	HAVE_TGI
extern int tgipipe[2];
#endif
//extern int mainpid;
extern char df_used[4], df_free[4];
extern bool restart_server;
extern __EXPORT MappedUsage *usage;

#ifdef CCXX_NAMESPACES
}
#endif
