dnl Copyright (C) 1999 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN([OST_ODBC],[
	ost_cv_odbc_database=false
	AC_CHECK_HEADER(odbc/sql.h,[
		AC_DEFINE(HAVE_ODBC_SQL_H, [1], [offset odbc header])
		ost_cv_odbc_database=true
	],[
		AC_CHECK_HEADER(sql.h,[
			AC_DEFINE(HAVE_SQL_H, [1], [local odbc header])
			ost_cv_odbc_database=true
		])		
	])
	if "$ost_cv_odbc_database" = "true" ; then
		ODBC_LIB="-liodbc"
		AC_CHECK_LIB(odbc, SQLConnect,
			ODBC_LIB="-lodbc")
		AC_SUBST(ODBC_LIB)
	fi
])

AC_DEFUN([OST_POSTGRES],[
	POSTGRES_FLAGS=""
	ost_cv_postgres_database=false
	AC_CHECK_HEADER(libpq-fe.h,[
		AC_DEFINE(HAVE_LIBPQ_FE_H, [1], [has postgresql libs])
		ost_cv_postgres_database=true
	],[
		AC_CHECK_HEADER(pgsql/libpq-fe.h,[
			POSTGRES_FLAGS="-I${includedir}/pgsql"
			AC_DEFINE(HAVE_PGSQL_LIBPQ_FE_H, [1], [alternate libpq install])
			ost_cv_postgres_database=true
		],[
	                AC_CHECK_HEADER(postgresql/libpq-fe.h,[
        	                POSTGRES_FLAGS="-I${includedir}/postgresql"
                	        AC_DEFINE(HAVE_POSTGRESQL_LIBPQ_FE_H, [1], [alternate libpq2])
                        	ost_cv_postgres_database=true
			])
		])
	])
	AC_SUBST(POSTGRES_FLAGS)
])

AC_DEFUN([OST_MYSQL],[
	MYSQL_FLAGS=""
	MYSQL_LIBS="-lmysqlclient_r"
        ost_cv_mysql_database=false
        AC_CHECK_HEADER(mysql.h,[
                AC_DEFINE(HAVE_MYSQL_H, [1], [has mysql libs])
                ost_cv_mysql_database=true
        ],[
                AC_CHECK_HEADER(mysql/mysql.h,[
			MYSQL_LIBS="-L${libdir}/mysql -L/usr/lib/mysql $MYSQL_LIBS"
			MYSQL_FLAGS="-I${includedir}/mysql"
                        AC_DEFINE(HAVE_MYSQL_MYSQL_H, [1], [alternate libs])
                        ost_cv_mysql_database=true
                ])
        ])
        AC_SUBST(MYSQL_FLAGS)
	AC_SUBST(MYSQL_LIBS)
])

