// Copyright (C) 2000 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

MysqlQueue *MysqlQueue::first = NULL;

MysqlQueue::MysqlQueue(ScriptCommand *c) :
ThreadQueue(c->getLast("name"), mysql.getPriority(), mysql.getStack())
{
	const char *cp;

	cmd = c;
	cmd->setThreadQueue(this);
        user = mysql.getLast("user");
        pass = mysql.getLast("password");
	dbname = cmd->getLast("dsn");
	if(!dbname)
		dbname = cmd->getLast("database");

	if(!dbname && cmd == aascript)
		dbname = mysql.getLast("database");

	cp = mysql.getLast("port");
	if(cp)
		port = atoi(cp);

	host = mysql.getLast("host");
	if(!host)
		host = mysql.getLast("server");

	group = mysql.getLast("group");
	if(!group)
		group = keyserver.getLast("group");

	if(!group)
		group = "bayonne";

	cdrtable = "calls";

	cdrlist = cmd->getLast("calls");
	if(!cdrlist && cmd == aascript)
		cdrlist = mysql.getLast("calls");
	if(!cdrlist)
	{
		cdrtable = "cdr";
		cdrlist = cmd->getLast("cdr");
	}
	if(!cdrlist && cmd == aascript)
		cdrlist = mysql.getLast("cdr");

	if(!cdrlist)
		cdrtable = NULL;

	next = first;
	first = this;
}

void MysqlQueue::cdr(ScriptInterp *interp)
{
	char sql[256];
	char list[256];
	char varname[65];
	const char *cp;
	bool first = true;
	unsigned len;
	char *tok;

	if(!cdrtable)
		return;

        snprintf(sql, sizeof(sql), "insert into %s values (", cdrtable);
        snprintf(list, sizeof(list), "%s", cdrlist);
        cp = strtok_r(list, ",;: \t\n", &tok);
        while(cp)
        {
                len = strlen(sql);
		if(!strchr(cp, '.'))
		{
			snprintf(varname, sizeof(varname), "session.%s", cp);
			cp = varname;
		}
                cp = interp->getSymbol(cp);
                if(!cp)
                        cp = "";
                if(first)
                        snprintf(sql + len, sizeof(sql) - len - 1, "\'%s\'", cp);
                else
                        snprintf(sql + len, sizeof(sql) - len - 1, ",\'%s\'", cp);
                first = false;
                cp = strtok_r(NULL, ",;: \t\n", &tok);
        }
        len = strlen(sql);
        sql[len++] = ')';
        sql[len++] = 0;
        post(sql, len);
}

void MysqlQueue::startQueue(void)
{
	char buf[256];
	const char *errmsg;

	connected = false;
	mysql_init(&conn);
	mysql_options(&conn, MYSQL_READ_DEFAULT_GROUP, group);
       	if(!mysql_real_connect(&conn, host, user, pass, dbname, port, NULL, 0))
	{
		errmsg = mysql_error(&conn);
		errlog("failed", "Database=%s, Error=%s", dbname, errmsg);
		return;
	}
	connected = true;
}

void MysqlQueue::stopQueue(void)
{
	if(!connected)
		return;

	mysql_close(&conn);
	connected = false;
}

void MysqlQueue::runQueue(void *data)
{
	const char *errmsg;

	query = (const char *)data;
	if(!connected)
		return;

	if(mysql_real_query(&conn, query, strlen(query)) != 0)
	{
		errmsg = mysql_error(&conn);
		errlog("failed", "Database=%s; Error=%s", dbname, errmsg);
	}
}

#ifdef	CCXX_NAMESPACES
}
#endif
