// Copyright (C) 2000 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

MysqlThread::MysqlThread(const char *dsn, const char *r, Trunk *trk):
Service(trk, mysql.getPriority(), mysql.getStack())
{
	dbname = dsn;
	results = r;
}

void MysqlThread::run(void)
{
	ScriptCommand *cmd = trunk->getCommand();
	MYSQL_RES *res = (MYSQL_RES *)trunk->getPointer(SYM_SQLRESULTS);
	MYSQL *conn = (MYSQL *)cmd->getDatabase();	
	MYSQL_ROW sqlrow;
	char buf[256];
	const char *query = trunk->getKeyword("query");
	const char *user, *password;
	unsigned len = 0, port = 0;
	const char *opt, *host;
	const char *errmsg;
	const char *group;
	unsigned row = 0, col = 0, rows, cols;
	const char *token = trunk->getKeyword("token");
	int fc;

	if(!token)
		token = ",";

	cmd->dblock.enterMutex();
	if(!conn)
	{

		user = mysql.getLast("user");
		password = mysql.getLast("password");
		host = mysql.getLast("host");
		if(!host)
			host = mysql.getLast("server");
		 
		opt = mysql.getLast("port");
		if(opt)
			port = atoi(opt);

		group = mysql.getLast("group");
		if(!group)
			group = keyserver.getLast("group");
		if(!group)
			group = "bayonne";

		conn = new MYSQL;
		mysql_init(conn);
                mysql_options(conn, MYSQL_READ_DEFAULT_GROUP, group);
                if(!mysql_real_connect(conn, host, user, password, dbname, port, NULL, 0))
                {
                        slog(Slog::levelError) << "sql: failed to connect: " <<
                                mysql_error(conn) << endl;
			cmd->dblock.leaveMutex();
			delete conn;
			Service::failure();
                }
		cmd->setDatabase(conn);
                trunk->setConst(SYM_SQLCONNECT, dbname);
                slog.debug("mysql: %s: connected", dbname);
	}
	cmd->dblock.leaveMutex();
	trunk->setPointer(SYM_SQLRESULTS, NULL);
	if(res)
		mysql_free_result(res);
	
	if(!query && !trunk->getMember())
	{
		query = buf;
		while(len < sizeof(buf) && NULL != (opt = trunk->getValue(NULL)))
		{
			snprintf(buf + len, sizeof(buf) - len, "%s", opt);
			len = strlen(buf);
		}
	}
	if(!query)
		Service::success();

	trunk->setSymbol(SYM_SQLROW, "0");
	errmsg = NULL;

	if(mysql_ping(conn))
	{
		errlog("failed", "Database=%s; Error=Server Died", dbname);
		trunk->setSymbol(SYM_SQLERROR, "server died");
		Service::failure();
	}

	res = NULL;
	cmd->dblock.enterMutex();
	if(mysql_real_query(conn, query, strlen(query)) != 0)
	{
		errmsg = mysql_error(conn);
                errlog("failed", "Database=%s; Error=%s", dbname, errmsg);
                trunk->setSymbol(SYM_SQLERROR, errmsg);
		cmd->dblock.leaveMutex();
                Service::failure();
	}
	fc = mysql_field_count(conn);
	rows = mysql_affected_rows(conn);
	if(fc)
		res = mysql_store_result(conn);
	cmd->dblock.leaveMutex();
	if(!res)
	{
		snprintf(buf, sizeof(buf), "%d", rows);
		trunk->setSymbol(SYM_SQLCHANGES, buf);
		trunk->setSymbol(SYM_ROWS, "0");
		trunk->setSymbol(SYM_COLS, "0");
 	}
	else
	{
		rows = mysql_num_rows(res);
		cols = mysql_num_fields(res);
		snprintf(buf, sizeof(buf), "%d", rows);
		trunk->setSymbol(SYM_ROWS, buf);
		snprintf(buf, sizeof(buf), "%d", cols);
		trunk->setSymbol(SYM_COLS, buf);
	}
	
	if(res)
		trunk->setPointer(SYM_SQLRESULTS, res);

	if(!res || !results || rows < 1)
		Service::success();

	while((sqlrow = mysql_fetch_row(res)))
	{
		col = 0;
		while(col < cols)
		{
			if(!col)
				snprintf(buf, sizeof(buf), "%s", sqlrow[col]);
			else
				snprintf(buf + len, sizeof(buf) - len, "%c%s", *token, sqlrow[col]);
			++col;
			len = strlen(buf);
		}
		trunk->setVariable(results, 0, buf);
		++row;
	}

	Service::success();
}

#ifdef	CCXX_NAMESPACES
}
#endif
