// Copyright (C) 2000 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <bayonneserver.h>
#include <cstdlib>
#include <cstdio>
#ifdef	HAVE_ODBC_SQL_H
#include <odbc/sql.h>
#include <odbc/sqlext.h>
#include <odbc/sqltypes.h>
#else
#include <sql.h>
#include <sqlext.h>
#include <sqltypes.h>
#endif

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

class ODBCQueue: public ThreadQueue
{
private:
	friend class ODBCModule;

	static ODBCQueue *first;
	ODBCQueue *next;
	ScriptCommand *cmd;
        long err;
        SQLHSTMT hstmt;
	SQLHDBC hdbc;
	SQLCHAR errmsg[128];
        const char *user;
        const char *pass;
        SQLSMALLINT mlen, col, cols;
        char buf[256];
        const char *query;
	const char *dbname;

	void startQueue(void);
	void stopQueue(void);
	void runQueue(void *data);

public:
	ODBCQueue(ScriptCommand *cmd);
};

class ODBCThread: public Service
{
private:
	static Mutex lock;
	const char *dbname;
	const char *results;

public:
	ODBCThread(const char *dsn, const char *resname, Trunk *trk);
	void run(void);
};


class ODBCModule : protected Trunk::Database
{
private:
	friend class ODBCThread;
	friend class ODBCQueue;
	SQLHENV	hODBC;

	bool header(ScriptInterp *interp);
	bool fetch(ScriptInterp *interp, unsigned row);
	Service *getService(Trunk *trunk, Line *line, trunkdata_t *data);
	void moduleAttach(ScriptInterp *interp);
	void moduleDetach(ScriptInterp *interp, const char *script);
	int getPriority(void);
	size_t getStack(void);

public:
	ODBCModule();
	~ODBCModule();
};

extern ODBCModule odbc;

#ifdef	CCXX_NAMESPACES
}
#endif
