// Copyright (C) 2000 Open Source Telecom Corporation.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
using namespace std;
#endif

ODBCQueue *ODBCQueue::first = NULL;

ODBCQueue::ODBCQueue(ScriptCommand *c) : 
ThreadQueue(c->getLast("name"), odbc.getPriority(), odbc.getStack())
{
	cmd = c;
	cmd->setThreadQueue(this);
        user = odbc.getLast("user");
        pass = odbc.getLast("password");
	dbname = cmd->getLast("dsn");
	if(!dbname)
		dbname = cmd->getLast("database");

	if(!dbname && cmd == aascript)
		dbname = odbc.getLast("database");

	if(!user)
		user = "";

	if(!pass)
		pass = "";

	next = first;
	first = this;
        err = SQLAllocHandle(SQL_HANDLE_DBC, odbc.hODBC, &hdbc);
        if(err != SQL_SUCCESS && err != SQL_SUCCESS_WITH_INFO)
        {
                errlog("error", "Database=%s; Error=%s", dbname, errmsg);
                hdbc = NULL;
        }
        SQLSetConnectAttr(hdbc, SQL_LOGIN_TIMEOUT, (SQLPOINTER *)5, 0);
}

void ODBCQueue::startQueue(void)
{
        err = SQLConnect(hdbc, (SQLCHAR *)dbname, SQL_NTS, (SQLCHAR *)user, SQL_NTS, (SQLCHAR *)pass, SQL_NTS);
	if(err != SQL_SUCCESS && err != SQL_SUCCESS_WITH_INFO)
        {
	        errlog("error", "Database=%s; Error=%s", dbname, errmsg);		
                SQLFreeHandle(SQL_HANDLE_DBC, hdbc);
		hdbc = NULL;
		return;
	}
}		

void ODBCQueue::stopQueue(void)
{
	if(hdbc == NULL)
		return;

	SQLDisconnect(hdbc);
}

void ODBCQueue::runQueue(void *data)
{
	query = (const char *)data;
}

#ifdef	CCXX_NAMESPACES
}
#endif
